/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.definitions.AEItems;
import appeng.menu.implementations.UpgradeableMenu;
import com.glodblock.github.extendedae.container.ContainerTagExportBus;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.CEAEGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import java.util.regex.Pattern;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class GuiTagExportBus
extends UpgradeableScreen<ContainerTagExportBus>
implements IActionHolder {
    private final ActionMap actions = ActionMap.create();
    private final SettingToggleButton<RedstoneMode> redstoneMode = new ServerSettingToggleButton(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
    private final AETextField filterInputs;
    private final AETextField filterInputs2;
    private static final Pattern ORE_DICTIONARY_FILTER = Pattern.compile("[0-9a-zA-Z* &|^!():/_]*");

    public GuiTagExportBus(ContainerTagExportBus menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.addToLeftToolbar((Button)this.redstoneMode);
        this.filterInputs = this.widgets.addTextField("filter_input");
        this.filterInputs.setFilter(str -> ORE_DICTIONARY_FILTER.matcher((CharSequence)str).matches());
        this.filterInputs.setMaxLength(1024);
        this.filterInputs.setPlaceholder((Component)Component.translatable((String)"gui.extendedae.tag_storage_bus.tooltip"));
        this.filterInputs.setResponder(s -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("set", s, true)));
        this.filterInputs2 = this.widgets.addTextField("filter_input_2");
        this.filterInputs2.setFilter(str -> ORE_DICTIONARY_FILTER.matcher((CharSequence)str).matches());
        this.filterInputs2.setMaxLength(1024);
        this.filterInputs2.setPlaceholder((Component)Component.translatable((String)"gui.extendedae.tag_storage_bus.tooltip"));
        this.filterInputs2.setResponder(s -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("set", s, false)));
        this.actions.put("init", o -> {
            this.filterInputs.setValue((String)o.get(0));
            this.filterInputs2.setValue((String)o.get(1));
        });
        EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("update"));
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.filterInputs.isMouseOver(xCoord, yCoord)) {
            this.filterInputs.setValue("");
        }
        if (btn == 1 && this.filterInputs2.isMouseOver(xCoord, yCoord)) {
            this.filterInputs2.setValue("");
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.redstoneMode.set((Enum)((ContainerTagExportBus)this.menu).getRedStoneMode());
        this.redstoneMode.setVisibility(((ContainerTagExportBus)this.menu).hasUpgrade((ItemLike)AEItems.REDSTONE_CARD));
    }

    protected void init() {
        super.init();
        this.setInitialFocus((GuiEventListener)this.filterInputs);
    }
}

