/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.level.levelgen.feature;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class MobFeature
extends Feature<NoneFeatureConfiguration> {
    private final WeightedRandomList<WeightedEntry.Wrapper<Holder<? extends EntityType<? extends Mob>>>> entityTypes;

    public MobFeature(Holder<? extends EntityType<? extends Mob>> entityType) {
        this((WeightedRandomList<WeightedEntry.Wrapper<Holder<? extends EntityType<? extends Mob>>>>)WeightedRandomList.create((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.wrap(entityType, (int)1)}));
    }

    public MobFeature(WeightedRandomList<WeightedEntry.Wrapper<Holder<? extends EntityType<? extends Mob>>>> entityTypes) {
        super(NoneFeatureConfiguration.CODEC);
        this.entityTypes = entityTypes;
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos position = context.origin().below();
        Mob mob = this.entityTypes.getRandom(context.random()).map(WeightedEntry.Wrapper::data).map(Holder::value).map(entityType -> (Mob)entityType.create((Level)context.level().getLevel())).orElse(null);
        if (mob != null) {
            mob.moveTo((double)position.getX() + 0.5, (double)position.getY(), (double)position.getZ() + 0.5, 0.0f, 0.0f);
            mob.finalizeSpawn((ServerLevelAccessor)context.level(), context.level().getCurrentDifficultyAt(position), MobSpawnType.SPAWNER, null);
            mob.setPersistenceRequired();
            context.level().addFreshEntity((Entity)mob);
            return true;
        }
        return false;
    }
}

