/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.world.entity.monster;

import com.google.common.collect.ImmutableMap;
import fuzs.eternalnether.init.ModSoundEvents;
import fuzs.puzzleslib.api.item.v2.ItemHelper;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class WarpedEnderMan
extends EnderMan {
    private static final Map<SoundEvent, SoundEvent> SOUND_EVENTS = ImmutableMap.of((Object)SoundEvents.ENDERMAN_AMBIENT, (Object)((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_AMBIENT.value()), (Object)SoundEvents.ENDERMAN_DEATH, (Object)((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_DEATH.value()), (Object)SoundEvents.ENDERMAN_HURT, (Object)((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_HURT.value()), (Object)SoundEvents.ENDERMAN_SCREAM, (Object)((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_SCREAM.value()), (Object)SoundEvents.ENDERMAN_STARE, (Object)((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_STARE.value()), (Object)SoundEvents.ENDERMAN_TELEPORT, (Object)((SoundEvent)ModSoundEvents.WARPED_ENDERMAN_TELEPORT.value()));
    private static final int SHEAR_COOLDOWN = 20;
    private static final WarpedEnderManVariant[] VARIANTS = WarpedEnderManVariant.values();
    private static final EntityDataAccessor<Integer> VARIANT_ID = SynchedEntityData.defineId(WarpedEnderMan.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private WarpedEnderManVariant variant;
    private int shearCooldownCounter = 0;
    private boolean toConvertToEnderman = false;

    public WarpedEnderMan(EntityType<? extends EnderMan> entityType, Level world) {
        super(entityType, world);
        this.setVariant(WarpedEnderMan.randomVariant(this.getRandom()));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 55.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 8.5).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.shearCooldownCounter > 0) {
                --this.shearCooldownCounter;
            } else if (this.shearCooldownCounter < 0) {
                this.shearCooldownCounter = 0;
            }
            if (this.toConvertToEnderman) {
                EnderMan enderman = (EnderMan)this.convertTo(EntityType.ENDERMAN, false);
                this.playShearSound(enderman);
            }
        }
    }

    public void playSound(SoundEvent event, float volume, float pitch) {
        super.playSound(SOUND_EVENTS.getOrDefault(event, event), volume, pitch);
    }

    private void playShearSound(EnderMan enderman) {
        this.level().playSound(null, (Entity)enderman, SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT_ID, (Object)2);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Variant", this.variant.ordinal());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setVariant(VARIANTS[tag.getInt("Variant")]);
    }

    public WarpedEnderManVariant getVariant() {
        WarpedEnderManVariant ret;
        this.variant = ret = VARIANTS[(Integer)this.entityData.get(VARIANT_ID)];
        return ret;
    }

    public void setVariant(WarpedEnderManVariant variant) {
        this.variant = variant;
        this.entityData.set(VARIANT_ID, (Object)variant.ordinal());
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (itemInHand.is(Items.SHEARS)) {
            if (this.isReadyForShearing() && !this.level().isClientSide) {
                boolean flag = this.toConvertToEnderman;
                this.shearWarp();
                this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                ItemHelper.hurtAndBreak((ItemStack)itemInHand, (int)1, (LivingEntity)player, (InteractionHand)interactionHand);
                if (this.toConvertToEnderman && !flag && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, (Entity)this);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, interactionHand);
    }

    private boolean isReadyForShearing() {
        return this.shearCooldownCounter == 0;
    }

    private void shearWarp() {
        ItemStack itemstack = new ItemStack((ItemLike)Items.TWISTING_VINES, this.getRandom().nextInt(2) + 1);
        BehaviorUtils.throwItem((LivingEntity)this, (ItemStack)itemstack, (Vec3)Vec3.ZERO.add(0.0, 1.0, 0.0));
        this.shearCooldownCounter = 20;
        switch (this.variant.ordinal()) {
            case 0: {
                this.toConvertToEnderman = true;
                break;
            }
            case 1: {
                this.setVariant(WarpedEnderManVariant.FRESH);
                this.playShearSound(this);
                break;
            }
            case 2: {
                this.setVariant(WarpedEnderManVariant.SHORT_VINE);
                this.playShearSound(this);
            }
        }
    }

    private static WarpedEnderManVariant randomVariant(RandomSource random) {
        return VARIANTS[random.nextInt(VARIANTS.length)];
    }

    public static enum WarpedEnderManVariant {
        FRESH,
        SHORT_VINE,
        LONG_VINE;

    }
}

