/*
 * Decompiled with CFR 0.152.
 */
package fuzs.eternalnether.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import fuzs.eternalnether.world.entity.monster.Wex;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class WexModel
extends HumanoidModel<Wex> {
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public WexModel(ModelPart part) {
        super(part);
        this.leftLeg.visible = false;
        this.hat.visible = false;
        this.rightWing = part.getChild("right_wing");
        this.leftWing = part.getChild("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, -1.0f, -2.0f, 6.0f, 10.0f, 4.0f), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        partDefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 32).addBox(-20.0f, 0.0f, 0.0f, 20.0f, 12.0f, 1.0f), PartPose.ZERO);
        partDefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 32).mirror().addBox(0.0f, 0.0f, 0.0f, 20.0f, 12.0f, 1.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    protected Iterable<ModelPart> bodyParts() {
        return Iterables.concat((Iterable)super.bodyParts(), (Iterable)ImmutableList.of((Object)this.rightWing, (Object)this.leftWing));
    }

    public void setupAnim(Wex wex, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.setupAnim((LivingEntity)wex, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (wex.isCharging()) {
            if (wex.getMainHandItem().isEmpty()) {
                this.rightArm.xRot = 4.712389f;
                this.leftArm.xRot = 4.712389f;
            } else if (wex.getMainArm() == HumanoidArm.RIGHT) {
                this.rightArm.xRot = 3.7699115f;
            } else {
                this.leftArm.xRot = 3.7699115f;
            }
        }
        float f = 0.47123894f;
        this.rightLeg.xRot += 0.62831855f;
        this.rightWing.z = 2.0f;
        this.leftWing.z = 2.0f;
        this.rightWing.y = 1.0f;
        this.leftWing.y = 1.0f;
        this.rightWing.yRot = f + Mth.cos((float)(ageInTicks * 45.836624f * ((float)Math.PI / 180))) * (float)Math.PI * 0.05f;
        this.leftWing.yRot = -this.rightWing.yRot;
        this.leftWing.zRot = -f;
        this.leftWing.xRot = f;
        this.rightWing.xRot = f;
        this.rightWing.zRot = f;
    }
}

