/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal.chunkUpdating;

import com.google.common.cache.CacheBuilder;
import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.api.internal.chunkUpdating.ChunkPosQueue;
import com.seibel.distanthorizons.core.api.internal.chunkUpdating.ChunkUpdateData;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.enums.EMinecraftColor;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public class ChunkUpdateQueueManager {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    public final ChunkPosQueue updateQueue;
    public final ChunkPosQueue preUpdateQueue;
    public final Set<DhChunkPos> ignoredChunkPosSet = Collections.newSetFromMap(new ConcurrentHashMap());
    public final ConcurrentMap<DhChunkPos, IChunkWrapper> queuedChunkWrapperByChunkPos = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build().asMap();
    public int maxSize = 500;
    private static long lastOverloadedLogMessageMsTime = 0L;

    public ChunkUpdateQueueManager() {
        this.updateQueue = new ChunkPosQueue();
        this.preUpdateQueue = new ChunkPosQueue();
    }

    public boolean contains(DhChunkPos pos) {
        return this.updateQueue.contains(pos) || this.ignoredChunkPosSet.contains(pos) || this.preUpdateQueue.contains(pos);
    }

    public void clear() {
        this.updateQueue.clear();
        this.preUpdateQueue.clear();
        this.ignoredChunkPosSet.clear();
    }

    public int getQueuedCount() {
        return this.updateQueue.getQueuedCount() + this.preUpdateQueue.getQueuedCount();
    }

    public boolean isEmpty() {
        return this.updateQueue.isEmpty() && this.preUpdateQueue.isEmpty();
    }

    public void addItemToPreUpdateQueue(DhChunkPos pos, ChunkUpdateData updateData) {
        this.addItemToQueue(pos, updateData, this.preUpdateQueue);
    }

    public void addItemToUpdateQueue(DhChunkPos pos, ChunkUpdateData updateData) {
        this.addItemToQueue(pos, updateData, this.updateQueue);
    }

    private void addItemToQueue(DhChunkPos pos, ChunkUpdateData updateData, ChunkPosQueue queue) {
        ChunkUpdateData removedData;
        int remainingSlots = this.maxSize - this.getQueuedCount();
        if (remainingSlots <= 0 && (removedData = queue.popFurthest()) != null) {
            this.queuedChunkWrapperByChunkPos.remove(removedData.chunkWrapper.getChunkPos());
        }
        queue.addItem(pos, updateData);
        this.queuedChunkWrapperByChunkPos.putIfAbsent(pos, updateData.chunkWrapper);
        remainingSlots = this.maxSize - this.getQueuedCount();
        if (remainingSlots <= 0) {
            this.sendOverloadMessage();
        }
    }

    private void sendOverloadMessage() {
        long msBetweenLastLog = System.currentTimeMillis() - lastOverloadedLogMessageMsTime;
        if (msBetweenLastLog >= 30000L) {
            lastOverloadedLogMessageMsTime = System.currentTimeMillis();
            String message = (Object)((Object)EMinecraftColor.ORANGE) + "Distant Horizons overloaded, too many chunks queued for LOD processing. " + (Object)((Object)EMinecraftColor.CLEAR_FORMATTING) + "\nThis may result in holes in your LODs. \nFix: move through the world slower, decrease your vanilla render distance, slow down your world pre-generator (IE Chunky), or increase the Distant Horizons' CPU thread counts. \nMax queue count [" + SharedApi.CHUNK_UPDATE_QUEUE_MANAGER.maxSize + "] ([" + 1000 + "] per thread+players).";
            boolean showWarningInChat = Config.Common.Logging.Warning.showUpdateQueueOverloadedChatWarning.get();
            if (showWarningInChat) {
                ClientApi.INSTANCE.showChatMessageNextFrame(message);
            }
            EWorldEnvironment environment = SharedApi.getEnvironment();
            if (showWarningInChat || environment == EWorldEnvironment.SERVER_ONLY) {
                LOGGER.warn(message, new Object[0]);
            }
        }
    }

    @Nullable
    public IChunkWrapper tryGetChunk(DhChunkPos pos) {
        IChunkWrapper existingWrapper = (IChunkWrapper)this.queuedChunkWrapperByChunkPos.get(pos);
        if (existingWrapper == null) {
            return null;
        }
        return existingWrapper.copy();
    }

    public void addPosToIgnore(DhChunkPos chunkPos) {
        this.ignoredChunkPosSet.add(chunkPos);
    }

    public void removePosToIgnore(DhChunkPos chunkPos) {
        this.ignoredChunkPosSet.remove(chunkPos);
    }

    public void setCenter(DhChunkPos newCenter) {
        this.updateQueue.setCenter(newCenter);
        this.preUpdateQueue.setCenter(newCenter);
    }
}

