/*
 * Decompiled with CFR 0.152.
 */
package net.imasillylittleguy.cnc.procedures;

import com.mojang.blaze3d.shaders.FogShape;
import javax.annotation.Nullable;
import net.imasillylittleguy.cnc.entity.WechugeEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;

@EventBusSubscriber(value={Dist.CLIENT})
public class FogDistanceSetupProcedure {
    public static ViewportEvent.RenderFog provider = null;

    public static void setDistance(float start, float end) {
        provider.setNearPlaneDistance(start);
        provider.setFarPlaneDistance(end);
        if (!provider.isCanceled()) {
            provider.setCanceled(true);
        }
    }

    public static void setShape(FogShape shape) {
        provider.setFogShape(shape);
        if (!provider.isCanceled()) {
            provider.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderFog(ViewportEvent.RenderFog event) {
        provider = event;
        if (provider.getMode() == FogRenderer.FogMode.FOG_TERRAIN) {
            ClientLevel level = Minecraft.getInstance().level;
            Entity entity = provider.getCamera().getEntity();
            if (level != null && entity != null) {
                Vec3 pos = entity.getPosition((float)provider.getPartialTick());
                FogDistanceSetupProcedure.execute((Event)provider, (LevelAccessor)level, pos.x(), pos.y(), pos.z());
            }
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z) {
        FogDistanceSetupProcedure.execute(null, world, x, y, z);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z) {
        if (!world.getEntitiesOfClass(WechugeEntity.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)24.0, (double)24.0, (double)24.0), e -> true).isEmpty()) {
            FogDistanceSetupProcedure.setShape(FogShape.CYLINDER);
            FogDistanceSetupProcedure.setDistance(20.0f, 40.0f);
        }
        if (!world.getEntitiesOfClass(WechugeEntity.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)12.0, (double)12.0, (double)12.0), e -> true).isEmpty()) {
            FogDistanceSetupProcedure.setShape(FogShape.SPHERE);
            FogDistanceSetupProcedure.setDistance(10.0f, 20.0f);
        }
    }
}

