/*
 * Decompiled with CFR 0.152.
 */
package net.imasillylittleguy.cnc.network;

import java.util.function.Supplier;
import net.imasillylittleguy.cnc.CncMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CncModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"cnc");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());
    public static boolean signed_contract = false;

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        CncMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        CncMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cnc", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cnc", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean whistles_cooldown = false;
        public double whistles = 0.0;
        public boolean never_show_again_beta = false;
        public boolean encountered_elk = false;
        public boolean encountered_beaver = false;
        public boolean encountered_black_bear = false;
        public boolean encountered_cougar = false;
        public boolean encountered_coyote = false;
        public boolean encountered_giant_boar = false;
        public boolean encountered_goose = false;
        public boolean encountered_greywolf = false;
        public boolean encountered_mouse = false;
        public boolean encountered_pit_viper = false;
        public boolean encountered_rattlesnake = false;
        public boolean encountered_ringtail = false;
        public boolean encountered_snake = false;
        public boolean encountered_whitetail = false;
        public boolean encountered_wolverine = false;
        public boolean encountered_wendigo = false;
        public boolean encountered_skinwalker = false;
        public boolean encountered_chupacabra = false;
        public boolean encountered_squonk = false;
        public boolean encountered_howler = false;
        public boolean encountered_sasquatch = false;
        public boolean recieved_field_guide = false;
        public boolean cipher_secret = false;
        public boolean encountered_wechuge = false;
        public boolean encountered_caribou = false;
        public boolean encountered_turkey = false;
        public boolean encountered_marmot = false;
        public boolean encountered_skunk = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("whistles_cooldown", this.whistles_cooldown);
            nbt.putDouble("whistles", this.whistles);
            nbt.putBoolean("never_show_again_beta", this.never_show_again_beta);
            nbt.putBoolean("encountered_elk", this.encountered_elk);
            nbt.putBoolean("encountered_beaver", this.encountered_beaver);
            nbt.putBoolean("encountered_black_bear", this.encountered_black_bear);
            nbt.putBoolean("encountered_cougar", this.encountered_cougar);
            nbt.putBoolean("encountered_coyote", this.encountered_coyote);
            nbt.putBoolean("encountered_giant_boar", this.encountered_giant_boar);
            nbt.putBoolean("encountered_goose", this.encountered_goose);
            nbt.putBoolean("encountered_greywolf", this.encountered_greywolf);
            nbt.putBoolean("encountered_mouse", this.encountered_mouse);
            nbt.putBoolean("encountered_pit_viper", this.encountered_pit_viper);
            nbt.putBoolean("encountered_rattlesnake", this.encountered_rattlesnake);
            nbt.putBoolean("encountered_ringtail", this.encountered_ringtail);
            nbt.putBoolean("encountered_snake", this.encountered_snake);
            nbt.putBoolean("encountered_whitetail", this.encountered_whitetail);
            nbt.putBoolean("encountered_wolverine", this.encountered_wolverine);
            nbt.putBoolean("encountered_wendigo", this.encountered_wendigo);
            nbt.putBoolean("encountered_skinwalker", this.encountered_skinwalker);
            nbt.putBoolean("encountered_chupacabra", this.encountered_chupacabra);
            nbt.putBoolean("encountered_squonk", this.encountered_squonk);
            nbt.putBoolean("encountered_howler", this.encountered_howler);
            nbt.putBoolean("encountered_sasquatch", this.encountered_sasquatch);
            nbt.putBoolean("recieved_field_guide", this.recieved_field_guide);
            nbt.putBoolean("cipher_secret", this.cipher_secret);
            nbt.putBoolean("encountered_wechuge", this.encountered_wechuge);
            nbt.putBoolean("encountered_caribou", this.encountered_caribou);
            nbt.putBoolean("encountered_turkey", this.encountered_turkey);
            nbt.putBoolean("encountered_marmot", this.encountered_marmot);
            nbt.putBoolean("encountered_skunk", this.encountered_skunk);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.whistles_cooldown = nbt.getBoolean("whistles_cooldown");
            this.whistles = nbt.getDouble("whistles");
            this.never_show_again_beta = nbt.getBoolean("never_show_again_beta");
            this.encountered_elk = nbt.getBoolean("encountered_elk");
            this.encountered_beaver = nbt.getBoolean("encountered_beaver");
            this.encountered_black_bear = nbt.getBoolean("encountered_black_bear");
            this.encountered_cougar = nbt.getBoolean("encountered_cougar");
            this.encountered_coyote = nbt.getBoolean("encountered_coyote");
            this.encountered_giant_boar = nbt.getBoolean("encountered_giant_boar");
            this.encountered_goose = nbt.getBoolean("encountered_goose");
            this.encountered_greywolf = nbt.getBoolean("encountered_greywolf");
            this.encountered_mouse = nbt.getBoolean("encountered_mouse");
            this.encountered_pit_viper = nbt.getBoolean("encountered_pit_viper");
            this.encountered_rattlesnake = nbt.getBoolean("encountered_rattlesnake");
            this.encountered_ringtail = nbt.getBoolean("encountered_ringtail");
            this.encountered_snake = nbt.getBoolean("encountered_snake");
            this.encountered_whitetail = nbt.getBoolean("encountered_whitetail");
            this.encountered_wolverine = nbt.getBoolean("encountered_wolverine");
            this.encountered_wendigo = nbt.getBoolean("encountered_wendigo");
            this.encountered_skinwalker = nbt.getBoolean("encountered_skinwalker");
            this.encountered_chupacabra = nbt.getBoolean("encountered_chupacabra");
            this.encountered_squonk = nbt.getBoolean("encountered_squonk");
            this.encountered_howler = nbt.getBoolean("encountered_howler");
            this.encountered_sasquatch = nbt.getBoolean("encountered_sasquatch");
            this.recieved_field_guide = nbt.getBoolean("recieved_field_guide");
            this.cipher_secret = nbt.getBoolean("cipher_secret");
            this.encountered_wechuge = nbt.getBoolean("encountered_wechuge");
            this.encountered_caribou = nbt.getBoolean("encountered_caribou");
            this.encountered_turkey = nbt.getBoolean("encountered_turkey");
            this.encountered_marmot = nbt.getBoolean("encountered_marmot");
            this.encountered_skunk = nbt.getBoolean("encountered_skunk");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "cnc_mapvars";
        public boolean whistling_enabled = false;
        public boolean is_beta = false;
        public boolean effigy_data = false;
        public boolean is_private_beta = false;
        public boolean crawler_spawn_checker = false;
        public boolean critter_spawn_checker = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.whistling_enabled = nbt.getBoolean("whistling_enabled");
            this.is_beta = nbt.getBoolean("is_beta");
            this.effigy_data = nbt.getBoolean("effigy_data");
            this.is_private_beta = nbt.getBoolean("is_private_beta");
            this.crawler_spawn_checker = nbt.getBoolean("crawler_spawn_checker");
            this.critter_spawn_checker = nbt.getBoolean("critter_spawn_checker");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putBoolean("whistling_enabled", this.whistling_enabled);
            nbt.putBoolean("is_beta", this.is_beta);
            nbt.putBoolean("effigy_data", this.effigy_data);
            nbt.putBoolean("is_private_beta", this.is_private_beta);
            nbt.putBoolean("crawler_spawn_checker", this.crawler_spawn_checker);
            nbt.putBoolean("critter_spawn_checker", this.critter_spawn_checker);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "cnc_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.whistles_cooldown = original.whistles_cooldown;
            clone.never_show_again_beta = original.never_show_again_beta;
            clone.encountered_elk = original.encountered_elk;
            clone.encountered_beaver = original.encountered_beaver;
            clone.encountered_black_bear = original.encountered_black_bear;
            clone.encountered_cougar = original.encountered_cougar;
            clone.encountered_coyote = original.encountered_coyote;
            clone.encountered_giant_boar = original.encountered_giant_boar;
            clone.encountered_goose = original.encountered_goose;
            clone.encountered_greywolf = original.encountered_greywolf;
            clone.encountered_mouse = original.encountered_mouse;
            clone.encountered_pit_viper = original.encountered_pit_viper;
            clone.encountered_rattlesnake = original.encountered_rattlesnake;
            clone.encountered_ringtail = original.encountered_ringtail;
            clone.encountered_snake = original.encountered_snake;
            clone.encountered_whitetail = original.encountered_whitetail;
            clone.encountered_wolverine = original.encountered_wolverine;
            clone.encountered_wendigo = original.encountered_wendigo;
            clone.encountered_skinwalker = original.encountered_skinwalker;
            clone.encountered_chupacabra = original.encountered_chupacabra;
            clone.encountered_squonk = original.encountered_squonk;
            clone.encountered_howler = original.encountered_howler;
            clone.encountered_sasquatch = original.encountered_sasquatch;
            clone.recieved_field_guide = original.recieved_field_guide;
            clone.cipher_secret = original.cipher_secret;
            clone.encountered_wechuge = original.encountered_wechuge;
            clone.encountered_caribou = original.encountered_caribou;
            clone.encountered_turkey = original.encountered_turkey;
            clone.encountered_marmot = original.encountered_marmot;
            clone.encountered_skunk = original.encountered_skunk;
            if (!event.isWasDeath()) {
                clone.whistles = original.whistles;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

