/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.parser.DoubleValueParser;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.TextBuilder;

public class GuiProgressbar
extends GuiControl {
    public double pos;
    public double max;
    public boolean showToolTip = true;
    public final DoubleValueParser parser;

    public GuiProgressbar(String name, double pos, double max) {
        this(name, pos, max, DoubleValueParser.PERCENT);
    }

    public GuiProgressbar(String name, double pos, double max, DoubleValueParser valueParser) {
        super(name);
        this.pos = pos;
        this.max = max;
        this.parser = valueParser;
    }

    @Override
    public void init() {
    }

    @Override
    public void closed() {
    }

    @Override
    public void tick() {
    }

    @Override
    public List<Component> getTooltip() {
        if (this.showToolTip) {
            return new TextBuilder().number(this.pos, true).text("/").number(this.max, true).text(" (").number(this.pos / this.max * 100.0, true).text("%)").build();
        }
        return super.getTooltip();
    }

    public double getPercentage() {
        return this.pos / this.max;
    }

    @Override
    public ControlFormatting getControlFormatting() {
        return ControlFormatting.PROGRESSBAR;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    protected void renderContent(GuiGraphics graphics, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
        this.renderProgress(graphics, control, rect, this.getPercentage());
        GuiRenderHelper.drawStringCentered(graphics, this.parser.parse(this.pos, this.max), (float)rect.getWidth(), (float)rect.getHeight(), this.getStyle().fontColor.toInt(), true);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Environment(value=EnvType.CLIENT)
    protected void renderProgress(GuiGraphics graphics, GuiChildControl control, Rect rect, double percent) {
        this.getStyle().clickable.render(graphics, 0.0, 0.0, (int)(rect.getWidth() * percent), rect.getHeight());
    }

    @Override
    public void flowX(int width, int preferred) {
    }

    @Override
    public void flowY(int width, int height, int preferred) {
    }

    @Override
    protected int preferredWidth(int availableWidth) {
        return 40;
    }

    @Override
    protected int preferredHeight(int width, int availableHeight) {
        return 10;
    }
}

