/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.transmissions;

import com.google.common.base.Preconditions;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class TransmissionSet {
    private final String name;
    private final Supplier<? extends Item> item;
    @Nullable
    private BlockEntry<? extends ShaftBlock> shaftBlock;
    @Nullable
    private BlockEntry<? extends CogWheelBlock> cogwheelBlock;
    @Nullable
    private BlockEntry<? extends CogWheelBlock> largeCogwheelBlock;
    @Nullable
    private Supplier<Function<BlockBehaviour.Properties, ? extends ShaftBlock>> shaftConstructor;
    @Nullable
    private Supplier<BiFunction<BlockBehaviour.Properties, Boolean, ? extends CogWheelBlock>> cogwheelConstructor;
    @Nullable
    private Supplier<BlockEntityType<?>> shaftBeType;
    @Nullable
    private Supplier<BlockEntityType<?>> cogwheelBeType;
    @Nullable
    private Supplier<BlockEntityType<?>> largeCogwheelBeType;
    private final boolean shaft;
    private final boolean cogwheel;
    private final boolean largeCogwheel;
    private final boolean notEncasable;
    private final boolean isKJSGenerated;

    protected TransmissionSet(String name, Options options) {
        this.name = name;
        this.item = options.item;
        this.shaft = options.shaft;
        this.cogwheel = options.cogwheel;
        this.largeCogwheel = options.largeCogwheel;
        this.notEncasable = options.notEncasable;
        this.isKJSGenerated = options.isKJSGenerated;
        this.shaftConstructor = options.shaftConstructor;
        this.cogwheelConstructor = options.cogwheelConstructor;
        this.shaftBeType = options.shaftBeType;
        this.cogwheelBeType = options.cogwheelBeType;
        this.largeCogwheelBeType = options.largeCogwheelBeType;
        if (options.existingShaft != null) {
            this.shaftBlock = options.existingShaft;
        }
        if (options.existingCogwheel != null) {
            this.cogwheelBlock = options.existingCogwheel;
        }
        if (options.existingLargeCogwheel != null) {
            this.largeCogwheelBlock = options.existingLargeCogwheel;
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean doesGenerateCogwheel() {
        return this.cogwheel;
    }

    public boolean doesGenerateShaft() {
        return this.shaft;
    }

    public boolean doesGenerateLargeCogwheel() {
        return this.largeCogwheel;
    }

    public Item getItem() {
        return this.item.get();
    }

    @Nullable
    public BlockEntry<? extends ShaftBlock> getShaftSupplier() {
        return this.shaftBlock;
    }

    @Nullable
    public ShaftBlock getShaft() {
        return this.shaftBlock == null ? null : (ShaftBlock)this.shaftBlock.get();
    }

    @Nullable
    public BlockEntry<? extends CogWheelBlock> getCogwheelSupplier() {
        return this.cogwheelBlock;
    }

    @Nullable
    public CogWheelBlock getCogwheel() {
        return this.cogwheelBlock == null ? null : (CogWheelBlock)this.cogwheelBlock.get();
    }

    @Nullable
    public BlockEntry<? extends CogWheelBlock> getLargeCogwheelSupplier() {
        return this.largeCogwheelBlock;
    }

    @Nullable
    public CogWheelBlock getLargeCogwheel() {
        return this.largeCogwheelBlock == null ? null : (CogWheelBlock)this.largeCogwheelBlock.get();
    }

    @Nullable
    public Function<BlockBehaviour.Properties, ? extends ShaftBlock> getShaftConstructor() {
        return this.shaftConstructor == null ? null : this.shaftConstructor.get();
    }

    @Nullable
    public BiFunction<BlockBehaviour.Properties, Boolean, ? extends CogWheelBlock> getCogwheelConstructor() {
        return this.cogwheelConstructor == null ? null : this.cogwheelConstructor.get();
    }

    @Nullable
    public BlockEntityType<?> getShaftBlockEntityType() {
        return this.shaftBeType == null ? null : this.shaftBeType.get();
    }

    @Nullable
    public BlockEntityType<?> getCogwheelBlockEntityType() {
        return this.cogwheelBeType == null ? null : this.cogwheelBeType.get();
    }

    @Nullable
    public BlockEntityType<?> getLargeCogwheelBlockEntityType() {
        return this.largeCogwheelBeType == null ? null : this.largeCogwheelBeType.get();
    }

    public void setShaft(@Nonnull BlockEntry<? extends ShaftBlock> shaft) {
        if (this.getShaftSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a shaft that has already been referenced");
        }
        this.shaftBlock = shaft;
    }

    public void setCogwheel(@Nonnull BlockEntry<? extends CogWheelBlock> cogwheel) {
        if (this.getCogwheelSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a cogwheel that has already been referenced");
        }
        this.cogwheelBlock = cogwheel;
    }

    public void setLargeCogwheel(@Nonnull BlockEntry<? extends CogWheelBlock> cogwheel) {
        if (this.getLargeCogwheelSupplier() != null) {
            throw new UnsupportedOperationException("You cannot modify a large cogwheel that has already been referenced");
        }
        this.largeCogwheelBlock = cogwheel;
    }

    public boolean isInSet(Block block) {
        return block.equals(this.getShaft()) || block.equals(this.getCogwheel()) || block.equals(this.getLargeCogwheel());
    }

    public boolean isNotEncasable() {
        return this.notEncasable;
    }

    public boolean isKJSGenerated() {
        return this.isKJSGenerated;
    }

    public static class Options {
        private Supplier<? extends Item> item;
        private boolean shaft = false;
        private boolean cogwheel = false;
        private boolean largeCogwheel = false;
        private boolean notEncasable;
        private boolean isKJSGenerated;
        @Nullable
        private BlockEntry<? extends ShaftBlock> existingShaft;
        @Nullable
        private BlockEntry<? extends CogWheelBlock> existingCogwheel;
        @Nullable
        private BlockEntry<? extends CogWheelBlock> existingLargeCogwheel;
        @Nullable
        private Supplier<Function<BlockBehaviour.Properties, ? extends ShaftBlock>> shaftConstructor;
        @Nullable
        private Supplier<BiFunction<BlockBehaviour.Properties, Boolean, ? extends CogWheelBlock>> cogwheelConstructor;
        @Nullable
        private Supplier<BlockEntityType<?>> shaftBeType;
        @Nullable
        private Supplier<BlockEntityType<?>> cogwheelBeType;
        @Nullable
        private Supplier<BlockEntityType<?>> largeCogwheelBeType;

        public Options item(Supplier<? extends Item> item) {
            Preconditions.checkNotNull(item, (Object)"Item Supplier can't be null");
            this.item = item;
            return this;
        }

        public Options shaft() {
            this.shaft = true;
            return this;
        }

        public Options cogwheel() {
            this.cogwheel = true;
            return this;
        }

        public Options largeCogwheel() {
            this.largeCogwheel = true;
            return this;
        }

        public Options notEncasable() {
            this.notEncasable = true;
            return this;
        }

        public Options shaftConstructor(Supplier<Function<BlockBehaviour.Properties, ? extends ShaftBlock>> constructor) {
            this.shaftConstructor = constructor;
            return this;
        }

        public Options cogwheelConstructor(Supplier<BiFunction<BlockBehaviour.Properties, Boolean, ? extends CogWheelBlock>> constructor) {
            this.cogwheelConstructor = constructor;
            return this;
        }

        public Options shaftBlockEntityType(Supplier<BlockEntityType<?>> beType) {
            this.shaftBeType = beType;
            return this;
        }

        public Options cogwheelBlockEntityType(Supplier<BlockEntityType<?>> beType) {
            this.cogwheelBeType = beType;
            return this;
        }

        public Options largeCogwheelBlockEntityType(Supplier<BlockEntityType<?>> beType) {
            this.largeCogwheelBeType = beType;
            return this;
        }

        public Options everything(Supplier<? extends Item> item) {
            return this.item(item).shaft().cogwheel().largeCogwheel();
        }

        Options existingShaft(BlockEntry<? extends ShaftBlock> shaft) {
            this.existingShaft = shaft;
            this.shaft = false;
            return this;
        }

        Options existingCogwheel(BlockEntry<? extends CogWheelBlock> cogwheel) {
            this.existingCogwheel = cogwheel;
            this.cogwheel = false;
            return this;
        }

        Options existingLargeCogwheel(BlockEntry<? extends CogWheelBlock> largeCogwheel) {
            this.existingLargeCogwheel = largeCogwheel;
            this.largeCogwheel = false;
            return this;
        }

        public Options kjsGenerated() {
            this.isKJSGenerated = true;
            return this;
        }
    }
}

