/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.basics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import mrbysco.constructionstick.ConstructionStick;
import mrbysco.constructionstick.api.IStickTemplate;
import mrbysco.constructionstick.api.IStickUpgrade;
import mrbysco.constructionstick.basics.ModTags;
import mrbysco.constructionstick.basics.ReplacementRegistry;
import mrbysco.constructionstick.config.ConstructionConfig;
import mrbysco.constructionstick.containers.ContainerManager;
import mrbysco.constructionstick.items.stick.ItemStick;
import mrbysco.constructionstick.stick.StickItemUseContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;

public class StickUtil {
    private static final List<IStickUpgrade> upgradeList = new ArrayList<IStickUpgrade>();

    public static boolean stackEquals(ItemStack stackA, ItemStack stackB) {
        return ItemStack.isSameItemSameComponents((ItemStack)stackA, (ItemStack)stackB);
    }

    public static boolean stackEquals(ItemStack stackA, Item item) {
        ItemStack stackB = new ItemStack((ItemLike)item);
        return StickUtil.stackEquals(stackA, stackB);
    }

    public static ItemStack holdingStick(Player player) {
        if (player.getItemInHand(InteractionHand.MAIN_HAND) != ItemStack.EMPTY && player.getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof ItemStick) {
            return player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        if (player.getItemInHand(InteractionHand.OFF_HAND) != ItemStack.EMPTY && player.getItemInHand(InteractionHand.OFF_HAND).getItem() instanceof ItemStick) {
            return player.getItemInHand(InteractionHand.OFF_HAND);
        }
        return null;
    }

    public static BlockPos posFromVec(Vec3 vec) {
        return new BlockPos((int)Math.round(vec.x), (int)Math.round(vec.y), (int)Math.round(vec.z));
    }

    public static Vec3 entityPositionVec(Entity entity) {
        return new Vec3(entity.getX(), entity.getY() + (double)(entity.getBbHeight() / 2.0f), entity.getZ());
    }

    public static Vec3 blockPosVec(BlockPos pos) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static List<ItemStack> getHotbar(Player player) {
        return player.getInventory().items.subList(0, 9);
    }

    public static List<ItemStack> getHotbarWithOffhand(Player player) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>(player.getInventory().items.subList(0, 9));
        inventory.addAll((Collection<ItemStack>)player.getInventory().offhand);
        return inventory;
    }

    public static List<ItemStack> getMainInv(Player player) {
        return player.getInventory().items.subList(9, player.getInventory().items.size());
    }

    public static List<ItemStack> getFullInv(Player player) {
        ArrayList<ItemStack> inventory = new ArrayList<ItemStack>((Collection<ItemStack>)player.getInventory().offhand);
        inventory.addAll((Collection<ItemStack>)player.getInventory().items);
        return inventory;
    }

    public static int blockDistance(BlockPos p1, BlockPos p2) {
        return Math.max(Math.abs(p1.getX() - p2.getX()), Math.abs(p1.getZ() - p2.getZ()));
    }

    public static boolean isTEAllowed(BlockState state) {
        if (!state.hasBlockEntity()) {
            return true;
        }
        ResourceLocation name = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock());
        if (name == null) {
            return false;
        }
        String fullId = name.toString();
        String modId = name.getNamespace();
        boolean inList = ((List)ConstructionConfig.BE_LIST.get()).contains(fullId) || ((List)ConstructionConfig.BE_LIST.get()).contains(modId);
        boolean isWhitelist = (Boolean)ConstructionConfig.BE_WHITELIST.get();
        return isWhitelist == inList;
    }

    public static boolean placeBlock(Level level, Player player, BlockState block, BlockPos pos, @Nullable BlockItem item) {
        ItemStack stack;
        BlockSnapshot snapshot = BlockSnapshot.create((ResourceKey)level.dimension(), (LevelAccessor)level, (BlockPos)pos);
        BlockEvent.EntityPlaceEvent placeEvent = new BlockEvent.EntityPlaceEvent(snapshot, block, (Entity)player);
        NeoForge.EVENT_BUS.post((Event)placeEvent);
        if (placeEvent.isCanceled()) {
            return false;
        }
        if (!level.setBlockAndUpdate(pos, block)) {
            ConstructionStick.LOGGER.info("Block could not be placed");
            return false;
        }
        if (item == null) {
            stack = new ItemStack((ItemLike)block.getBlock().asItem());
        } else {
            stack = new ItemStack((ItemLike)item);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
        }
        block.getBlock().setPlacedBy(level, pos, block, (LivingEntity)player, stack);
        return true;
    }

    public static boolean removeBlock(Level level, Player player, @Nullable BlockState block, BlockPos pos) {
        BlockState currentBlock = level.getBlockState(pos);
        if (!level.mayInteract(player, pos)) {
            return false;
        }
        if (!player.isCreative()) {
            if (currentBlock.getDestroySpeed((BlockGetter)level, pos) <= -1.0f || level.getBlockEntity(pos) != null) {
                return false;
            }
            if (block != null && !ReplacementRegistry.matchBlocks(currentBlock.getBlock(), block.getBlock())) {
                return false;
            }
        }
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(level, pos, currentBlock, player);
        NeoForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        level.removeBlock(pos, false);
        return true;
    }

    public static boolean replaceBlock(Level level, Player player, BlockState oldBlock, BlockState newBlock, BlockPos pos, BlockItem item) {
        if (!StickUtil.isBlockReplaceable(level, player, pos)) {
            return false;
        }
        if (!StickUtil.removeBlock(level, player, oldBlock, pos)) {
            return false;
        }
        if (!StickUtil.placeBlock(level, player, newBlock, pos, item)) {
            StickUtil.placeBlock(level, player, oldBlock, pos, null);
            return false;
        }
        return true;
    }

    public static int countItem(Player player, Item item) {
        if (player.getInventory().items == null) {
            return 0;
        }
        if (player.isCreative()) {
            return Integer.MAX_VALUE;
        }
        int total = 0;
        ContainerManager containerManager = ConstructionStick.containerManager;
        List<ItemStack> inventory = StickUtil.getFullInv(player);
        for (ItemStack stack : inventory) {
            if (stack == null || stack.isEmpty()) continue;
            if (StickUtil.stackEquals(stack, item)) {
                total += stack.getCount();
                continue;
            }
            int amount = containerManager.countItems(player, new ItemStack((ItemLike)item), stack);
            if (amount == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            total += amount;
        }
        return total;
    }

    private static boolean isPositionModifiable(Level level, Player player, BlockPos pos) {
        if (!level.isInWorldBounds(pos)) {
            return false;
        }
        if (!level.mayInteract(player, pos)) {
            return false;
        }
        return (Integer)ConstructionConfig.MAX_RANGE.get() <= 0 || StickUtil.blockDistance(player.blockPosition(), pos) <= (Integer)ConstructionConfig.MAX_RANGE.get();
    }

    public static boolean isPositionPlaceable(Level level, Player player, BlockPos pos, boolean replace) {
        if (!StickUtil.isPositionModifiable(level, player, pos)) {
            return false;
        }
        if (level.isEmptyBlock(pos)) {
            return true;
        }
        return replace && level.getBlockState(pos).canBeReplaced((BlockPlaceContext)new StickItemUseContext(level, player, new BlockHitResult(new Vec3(0.0, 0.0, 0.0), Direction.DOWN, pos, false), pos, (BlockItem)Items.STONE));
    }

    public static boolean isBlockRemovable(Level level, Player player, BlockPos pos) {
        if (!StickUtil.isPositionModifiable(level, player, pos)) {
            return false;
        }
        if (!player.isCreative()) {
            return !(level.getBlockState(pos).getDestroySpeed((BlockGetter)level, pos) <= -1.0f) && level.getBlockEntity(pos) == null;
        }
        return true;
    }

    public static boolean isBlockReplaceable(Level level, Player player, BlockPos pos) {
        if (!StickUtil.isPositionModifiable(level, player, pos)) {
            return false;
        }
        if (level.getBlockState(pos).is(ModTags.NON_REPLACEABLE)) {
            return false;
        }
        if (!player.isCreative()) {
            return !(level.getBlockState(pos).getDestroySpeed((BlockGetter)level, pos) <= -1.0f) && level.getBlockEntity(pos) == null;
        }
        return true;
    }

    public static boolean isBlockPermeable(Level level, BlockPos pos) {
        return level.isEmptyBlock(pos) || level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).isEmpty();
    }

    public static boolean entitiesCollidingWithBlock(Level level, BlockState blockState, BlockPos pos) {
        VoxelShape shape = blockState.getCollisionShape((BlockGetter)level, pos);
        if (!shape.isEmpty()) {
            AABB blockBB = shape.bounds().move(pos);
            return !level.getEntitiesOfClass(LivingEntity.class, blockBB, Predicate.not(Entity::isSpectator)).isEmpty();
        }
        return false;
    }

    public static Direction fromVector(Vec3 vector) {
        return Direction.getNearest((double)vector.x, (double)vector.y, (double)vector.z);
    }

    public static List<IStickUpgrade> getAllUpgrades() {
        if (upgradeList.isEmpty()) {
            for (Item item : BuiltInRegistries.ITEM) {
                if (!(item instanceof IStickUpgrade)) continue;
                IStickUpgrade upgrade = (IStickUpgrade)item;
                upgradeList.add(upgrade);
            }
        }
        return new ArrayList<IStickUpgrade>(upgradeList);
    }

    public static Optional<IStickTemplate> getUpgrade(ResourceLocation id) {
        for (IStickUpgrade upgrade : StickUtil.getAllUpgrades()) {
            IStickTemplate template;
            if (!(upgrade instanceof IStickTemplate) || !(template = (IStickTemplate)upgrade).getRegistryName().equals((Object)id)) continue;
            return Optional.of(template);
        }
        return Optional.empty();
    }
}

