/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.blocks.container;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import xxrexraptorxx.citycraft.recipes.IPaintingRecipe;
import xxrexraptorxx.citycraft.recipes.RecipeInputWrapper;
import xxrexraptorxx.citycraft.registry.ModBlocks;
import xxrexraptorxx.citycraft.registry.ModMenuTypes;
import xxrexraptorxx.citycraft.registry.ModRecipeTypes;

public class PainterMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT_1 = 0;
    public static final int INPUT_SLOT_2 = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final Level level;
    private List<RecipeHolder<IPaintingRecipe>> recipes = Lists.newArrayList();
    private final List<RecipeHolder<IPaintingRecipe>> allRecipes;
    private ItemStack input1 = ItemStack.EMPTY;
    private ItemStack input2 = ItemStack.EMPTY;
    long lastSoundTime;
    private final ContainerLevelAccess access;
    final Slot inputSlot1;
    final Slot inputSlot2;
    final Slot resultSlot;
    final ResultContainer resultContainer = new ResultContainer();
    Runnable slotUpdateListener = () -> {};
    private final DataSlot selectedRecipeIndex = DataSlot.standalone();
    private final List<Integer> inputSlotIndexes = List.of(Integer.valueOf(0), Integer.valueOf(1));
    private final Container container = new SimpleContainer(2){

        public void setChanged() {
            super.setChanged();
            PainterMenu.this.slotsChanged((Container)this);
            PainterMenu.this.slotUpdateListener.run();
        }
    };

    public PainterMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, ContainerLevelAccess.NULL);
    }

    public PainterMenu(int containerId, Inventory playerInventory, final ContainerLevelAccess access) {
        super((MenuType)ModMenuTypes.PAINTER.get(), containerId);
        this.level = playerInventory.player.level();
        this.access = access;
        this.allRecipes = this.level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.PAINTING.get());
        this.inputSlot1 = this.addSlot(new Slot(this.container, 0, 20, 20));
        this.inputSlot2 = this.addSlot(new Slot(this.container, 1, 20, 48));
        this.resultSlot = this.addSlot(new Slot((Container)this.resultContainer, 2, 143, 33){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                stack.onCraftedBy(player.level(), player, stack.getCount());
                PainterMenu.this.resultContainer.awardUsedRecipes(player, this.getRelevantItems());
                ItemStack inputStack1 = PainterMenu.this.inputSlot1.remove(1);
                ItemStack inputStack2 = PainterMenu.this.inputSlot2.remove(1);
                if (!inputStack1.isEmpty() || !inputStack2.isEmpty()) {
                    PainterMenu.this.setupResultSlot();
                }
                access.execute((world, pos) -> {
                    long time = world.getGameTime();
                    if (PainterMenu.this.lastSoundTime != time) {
                        world.playSound(null, pos, SoundEvents.BRUSH_GENERIC, SoundSource.BLOCKS, 1.0f, 1.0f);
                        PainterMenu.this.lastSoundTime = time;
                    }
                });
                super.onTake(player, stack);
            }

            private List<ItemStack> getRelevantItems() {
                ArrayList items = Lists.newArrayList();
                items.add(PainterMenu.this.inputSlot1.getItem());
                items.add(PainterMenu.this.inputSlot2.getItem());
                return items;
            }
        });
        int startX = 8;
        int startY = 84;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, startX + j * 18, startY + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, startX + k * 18, 142));
        }
        this.addDataSlot(this.selectedRecipeIndex);
    }

    public boolean stillValid(Player player) {
        return PainterMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.BLOCK_PAINTER.get()));
    }

    public boolean clickMenuButton(Player player, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIndex.set(id);
            this.setupResultSlot();
        }
        return true;
    }

    public void slotsChanged(Container inventory) {
        ItemStack stack1 = this.inputSlot1.getItem();
        ItemStack stack2 = this.inputSlot2.getItem();
        if (!stack1.is(this.input1.getItem()) || !stack2.is(this.input2.getItem())) {
            this.input1 = stack1.copy();
            this.input2 = stack2.copy();
            this.setupRecipeList(this.container, stack1, stack2);
        }
    }

    private void setupRecipeList(Container container, ItemStack stack1, ItemStack stack2) {
        this.recipes.clear();
        this.selectedRecipeIndex.set(-1);
        this.resultSlot.set(ItemStack.EMPTY);
        if (!stack1.isEmpty() && !stack2.isEmpty()) {
            this.recipes = this.level.getRecipeManager().getRecipesFor((RecipeType)ModRecipeTypes.PAINTING.get(), this.getRecipeInput(container), this.level);
        }
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            RecipeHolder<IPaintingRecipe> recipe = this.recipes.get(this.selectedRecipeIndex.get());
            ItemStack resultStack = ((IPaintingRecipe)recipe.value()).assemble(this.getRecipeInput(this.container), (HolderLookup.Provider)this.level.registryAccess());
            if (resultStack.isItemEnabled(this.level.enabledFeatures())) {
                this.resultContainer.setRecipeUsed(recipe);
                this.resultSlot.set(resultStack);
            } else {
                this.resultSlot.set(ItemStack.EMPTY);
            }
        } else {
            this.resultSlot.set(ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public void removed(Player player) {
        super.removed(player);
        this.resultContainer.removeItemNoUpdate(2);
        this.access.execute((p_40313_, p_40314_) -> this.clearContainer(player, this.container));
    }

    private RecipeInput getRecipeInput(Container inventory) {
        return new RecipeInputWrapper(inventory);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (index == 2) {
                if (!this.moveItemStackTo(stack, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack, itemstack);
            } else if (index >= 3 && index < 39) {
                if (!this.canMoveIntoInputSlots(stack)) {
                    return ItemStack.EMPTY;
                }
                int slotIndex = this.getSlotToQuickMoveTo(stack);
                if (!this.moveItemStackTo(stack, slotIndex, slotIndex + 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(stack, 3, 39, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
            this.broadcastChanges();
        }
        return itemstack;
    }

    public int getSlotToQuickMoveTo(ItemStack stack) {
        return this.allRecipes.stream().map(recipeMap -> PainterMenu.findSlotMatchingIngredient((IPaintingRecipe)recipeMap.value(), stack)).filter(Optional::isPresent).findFirst().orElse(Optional.of(1)).get();
    }

    private static Optional<Integer> findSlotMatchingIngredient(IPaintingRecipe recipe, ItemStack stack) {
        if (recipe.isBaseIngredient(stack)) {
            return Optional.of(0);
        }
        if (recipe.isColorIngredient(stack)) {
            return Optional.of(1);
        }
        return Optional.empty();
    }

    public boolean canMoveIntoInputSlots(ItemStack stack) {
        return this.level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.PAINTING.get()).stream().map(recipeMap -> PainterMenu.findSlotMatchingIngredient((IPaintingRecipe)recipeMap.value(), stack)).anyMatch(Optional::isPresent);
    }

    public int getResultSlot() {
        return 2;
    }

    public void registerUpdateListener(Runnable runnable) {
        this.slotUpdateListener = runnable;
    }

    private boolean isValidRecipeIndex(int id) {
        return id >= 0 && id < this.recipes.size();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public List<RecipeHolder<IPaintingRecipe>> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return this.inputSlot1.hasItem() && this.inputSlot2.hasItem() && !this.recipes.isEmpty();
    }
}

