/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.blocks;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class TrafficSignBlock
extends FenceBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public TrafficSignBlock() {
        super(BlockBehaviour.Properties.of().strength(3.0f, 4.0f).sound(SoundType.METAL).mapColor(DyeColor.WHITE).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        if (BuiltInRegistries.BLOCK.getKey((Object)Block.byItem((Item)stack.getItem())).getPath().contains("_eu_sign")) {
            list.add((Component)Component.literal((String)"[EU]").withStyle(ChatFormatting.GRAY));
        } else if (BuiltInRegistries.BLOCK.getKey((Object)Block.byItem((Item)stack.getItem())).getPath().contains("_us_sign")) {
            list.add((Component)Component.literal((String)"[US]").withStyle(ChatFormatting.GRAY));
        } else if (BuiltInRegistries.BLOCK.getKey((Object)Block.byItem((Item)stack.getItem())).getPath().contains("_cn_sign")) {
            list.add((Component)Component.literal((String)"[CN]").withStyle(ChatFormatting.GRAY));
        }
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, WEST, SOUTH, WATERLOGGED, FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    public boolean connectsTo(BlockState state, boolean isSideSolid, Direction direction) {
        return false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

