/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xxrexraptorxx.citycraft.registry.ModTags;

public class DoubleTrafficBarrierBlock
extends FenceBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape POST_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape FULL_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public DoubleTrafficBarrierBlock() {
        super(BlockBehaviour.Properties.of().strength(5.0f, 6.5f).sound(SoundType.METAL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.IRON_XYLOPHONE).requiresCorrectToolForDrops());
    }

    public boolean connectsTo(BlockState state, boolean isSideSolid, Direction direction) {
        boolean flag = this.isSameFence(state);
        return !DoubleTrafficBarrierBlock.isExceptionForConnection((BlockState)state) && isSideSolid || flag;
    }

    private boolean isSameFence(BlockState state) {
        return state.is(ModTags.TRAFFIC_BARRIERS_TAG);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue() || ((Boolean)state.getValue((Property)EAST)).booleanValue() || ((Boolean)state.getValue((Property)SOUTH)).booleanValue() || ((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            return FULL_SHAPE;
        }
        return POST_SHAPE;
    }
}

