/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.citycraft.blocks;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import xxrexraptorxx.citycraft.registry.ModBlocks;
import xxrexraptorxx.citycraft.utils.Config;

public class AsphaltSlabBlock
extends SlabBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public AsphaltSlabBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)ModBlocks.ASPHALT_BLOCK.get())));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        boolean isRegularAsphalt;
        if (level.isClientSide || entity == null) {
            return;
        }
        boolean isBoostAsphalt = this == ModBlocks.BOOST_ASPHALT_SLAB.get();
        boolean bl = isRegularAsphalt = !isBoostAsphalt && (Boolean)Config.ENABLE_ASPHALT_SPEED_EFFECT.get() != false;
        if (isRegularAsphalt || isBoostAsphalt) {
            int duration = isBoostAsphalt ? 30 : 10;
            int amplifier = isBoostAsphalt ? (Integer)Config.BOOST_SPEED_EFFECT_AMPLIFIER.get() : (Integer)Config.SPEED_EFFECT_AMPLIFIER.get();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, duration, amplifier, false, false, true));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        if (((Boolean)Config.ENABLE_TOOLTIPS.get()).booleanValue()) {
            if (this == ModBlocks.BOOST_ASPHALT_SLAB.get()) {
                list.add((Component)Component.translatable((String)"message.citycraft.boost_speed_tooltip").withStyle(ChatFormatting.GRAY));
            } else if (((Boolean)Config.ENABLE_ASPHALT_SPEED_EFFECT.get()).booleanValue() && this != ModBlocks.POTHOLE_ASPHALT_SLAB.get()) {
                list.add((Component)Component.translatable((String)"message.citycraft.speed_tooltip").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = context.getLevel().getBlockState(blockpos);
        if (blockstate.is((Block)this)) {
            return (BlockState)((BlockState)((BlockState)blockstate.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluidstate = context.getLevel().getFluidState(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        Direction direction = context.getClickedFace();
        return !(direction == Direction.DOWN || direction != Direction.UP && context.getClickLocation().y - (double)blockpos.getY() > 0.5) ? blockstate1 : (BlockState)blockstate1.setValue((Property)TYPE, (Comparable)SlabType.TOP);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

