/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunkyborder.shape.EllipseBorderShape;
import org.popcraft.chunkyborder.shape.PolygonBorderShape;
import org.popcraft.chunkyborder.util.ClientBorder;

public class PluginMessage {
    public static final int VERSION = 0;
    public static final byte[] INVALID_MESSAGE = ByteBuffer.allocate(4).putInt(-1).array();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ClientBorder readBorder(byte[] bytes) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);
             DataInputStream data = new DataInputStream(in);){
            int version = data.readInt();
            if (version != 0) return new ClientBorder(null, null);
            String worldKey = data.readUTF();
            byte type = data.readByte();
            ClientBorder clientBorder = switch (type) {
                case 1 -> {
                    int numPoints = data.readInt();
                    double[] pointsX = new double[numPoints];
                    double[] pointsZ = new double[numPoints];
                    for (int i = 0; i < numPoints; ++i) {
                        pointsX[i] = data.readDouble();
                        pointsZ[i] = data.readDouble();
                    }
                    yield new ClientBorder(worldKey, new PolygonBorderShape(pointsX, pointsZ));
                }
                case 2 -> {
                    double centerX = data.readDouble();
                    double centerZ = data.readDouble();
                    double radiusX = data.readDouble();
                    double radiusZ = data.readDouble();
                    yield new ClientBorder(worldKey, new EllipseBorderShape(centerX, centerZ, radiusX, radiusZ));
                }
                default -> new ClientBorder(worldKey, null);
            };
            return clientBorder;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ClientBorder(null, null);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] writeBorder(World world, Shape shape) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream data = new DataOutputStream(out);){
                data.writeInt(0);
                data.writeUTF(world.getKey());
                if (shape instanceof AbstractPolygon) {
                    AbstractPolygon polygon = (AbstractPolygon)shape;
                    data.writeByte(1);
                    List points = polygon.points();
                    data.writeInt(points.size());
                    for (Vector2 point : points) {
                        data.writeDouble(point.getX());
                        data.writeDouble(point.getZ());
                    }
                } else if (shape instanceof AbstractEllipse) {
                    AbstractEllipse ellipse = (AbstractEllipse)shape;
                    data.writeByte(2);
                    Vector2 center = ellipse.center();
                    Vector2 radii = ellipse.radii();
                    data.writeDouble(center.getX());
                    data.writeDouble(center.getZ());
                    data.writeDouble(radii.getX());
                    data.writeDouble(radii.getZ());
                } else {
                    data.writeByte(0);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return INVALID_MESSAGE;
        }
    }
}

