/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.util;

import java.util.ArrayList;
import java.util.List;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.util.Vector2;
import org.popcraft.chunky.platform.util.Vector3;
import org.popcraft.chunky.shape.AbstractEllipse;
import org.popcraft.chunky.shape.AbstractPolygon;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.shape.ShapeUtil;

public class Particles {
    private static int maxDistance = 8;
    private static int maxDistanceSquared = maxDistance * maxDistance;

    private Particles() {
    }

    public static void setMaxDistance(int maxDistance) {
        Particles.maxDistance = maxDistance;
        maxDistanceSquared = maxDistance * maxDistance;
    }

    public static List<Vector3> at(Player player, Shape border, double offsetPercent) {
        ArrayList<Vector3> particles;
        block6: {
            Vector3 pos;
            block7: {
                pos = player.getLocation().toVector();
                particles = new ArrayList<Vector3>();
                if (!(border instanceof AbstractPolygon)) break block7;
                AbstractPolygon polygon = (AbstractPolygon)border;
                List points = polygon.points();
                int numPoints = points.size();
                for (int i = 0; i < numPoints; ++i) {
                    double z;
                    double x;
                    Vector3 startPos;
                    Vector2 p1 = (Vector2)points.get(i);
                    Vector2 p2 = (Vector2)points.get(i == numPoints - 1 ? 0 : i + 1);
                    Vector2 closestPoint = ShapeUtil.closestPointOnLine((double)pos.getX(), (double)pos.getZ(), (double)p1.getX(), (double)p1.getZ(), (double)p2.getX(), (double)p2.getZ());
                    if (ShapeUtil.distanceBetweenPoints((double)pos.getX(), (double)pos.getZ(), (double)closestPoint.getX(), (double)closestPoint.getZ()) > (double)maxDistance) continue;
                    Vector2 unit = Vector2.of((double)(p2.getX() - p1.getX()), (double)(p2.getZ() - p1.getZ())).normalize();
                    double unitX = unit.getX();
                    double unitZ = unit.getZ();
                    double absUnitX = Math.abs(unitX);
                    double absUnitZ = Math.abs(unitZ);
                    double distanceFromStartX = Math.abs(closestPoint.getX() - p1.getX());
                    double distanceFromStartZ = Math.abs(closestPoint.getZ() - p1.getZ());
                    long unitsFromStartX = absUnitX == 0.0 ? 0L : (long)(distanceFromStartX / absUnitX);
                    long unitsFromStartZ = absUnitZ == 0.0 ? 0L : (long)(distanceFromStartZ / absUnitZ);
                    double startX = p1.getX() + (double)unitsFromStartX * unitX;
                    double startY = Math.floor(pos.getY());
                    double startZ = p1.getZ() + (double)unitsFromStartZ * unitZ;
                    double minX = Math.min(p1.getX(), p2.getX());
                    double minZ = Math.min(p1.getZ(), p2.getZ());
                    double maxX = Math.max(p1.getX(), p2.getX());
                    double maxZ = Math.max(p1.getZ(), p2.getZ());
                    double dx = -unitX;
                    double dz = -unitZ;
                    while (!(pos.distanceSquared(startPos = Vector3.of((double)(x = startX + dx), (double)startY, (double)(z = startZ + dz))) > (double)maxDistanceSquared)) {
                        List<Vector3> pointsBack = Particles.verticalPoints(pos, startPos, offsetPercent, unitX, unitZ, minX, minZ, maxX, maxZ);
                        particles.addAll(pointsBack);
                        dx -= unitX;
                        dz -= unitZ;
                    }
                    dx = 0.0;
                    dz = 0.0;
                    while (!(pos.distanceSquared(startPos = Vector3.of((double)(x = startX + dx), (double)startY, (double)(z = startZ + dz))) > (double)maxDistanceSquared)) {
                        List<Vector3> pointsForward = Particles.verticalPoints(pos, startPos, offsetPercent, unitX, unitZ, minX, minZ, maxX, maxZ);
                        particles.addAll(pointsForward);
                        dx += unitX;
                        dz += unitZ;
                    }
                }
                break block6;
            }
            if (!(border instanceof AbstractEllipse)) break block6;
            AbstractEllipse ellipse = (AbstractEllipse)border;
            Vector2 center = ellipse.center();
            Vector2 radii = ellipse.radii();
            double radius = Math.min(radii.getX(), radii.getZ());
            double angle = Math.acos((2.0 * radius * radius - 1.0) / (2.0 * radius * radius));
            double cameraAngle = Math.atan2(radii.getX() * (pos.getZ() - center.getZ()), radii.getZ() * (pos.getX() - center.getX()));
            double startY = Math.floor(pos.getY());
            double forwardStartAngle = Math.floor(cameraAngle / angle) * angle;
            double backwardStartAngle = forwardStartAngle - angle;
            double backwardStopAngle = backwardStartAngle - Math.PI;
            for (double da = backwardStartAngle; da > backwardStopAngle; da -= angle) {
                Vector2 start = ShapeUtil.pointOnEllipse((double)center.getX(), (double)center.getZ(), (double)radii.getX(), (double)radii.getZ(), (double)da);
                Vector2 end = ShapeUtil.pointOnEllipse((double)center.getX(), (double)center.getZ(), (double)radii.getX(), (double)radii.getZ(), (double)(da + angle));
                double minX = Math.min(start.getX(), end.getX());
                double minZ = Math.min(start.getZ(), end.getZ());
                double maxX = Math.max(start.getX(), end.getX());
                double maxZ = Math.max(start.getZ(), end.getZ());
                Vector3 startPos = Vector3.of((double)start.getX(), (double)startY, (double)start.getZ());
                List<Vector3> pointsBack = Particles.verticalPoints(pos, startPos, offsetPercent, end.getX() - start.getX(), end.getZ() - start.getZ(), minX, minZ, maxX, maxZ);
                if (pointsBack.isEmpty()) break;
                particles.addAll(pointsBack);
            }
            double forwardStopAngle = forwardStartAngle + Math.PI;
            for (double da = forwardStartAngle; da < forwardStopAngle; da += angle) {
                Vector2 start = ShapeUtil.pointOnEllipse((double)center.getX(), (double)center.getZ(), (double)radii.getX(), (double)radii.getZ(), (double)da);
                Vector2 end = ShapeUtil.pointOnEllipse((double)center.getX(), (double)center.getZ(), (double)radii.getX(), (double)radii.getZ(), (double)(da + angle));
                double minX = Math.min(start.getX(), end.getX());
                double minZ = Math.min(start.getZ(), end.getZ());
                double maxX = Math.max(start.getX(), end.getX());
                double maxZ = Math.max(start.getZ(), end.getZ());
                Vector3 startPos = Vector3.of((double)start.getX(), (double)startY, (double)start.getZ());
                List<Vector3> pointsBack = Particles.verticalPoints(pos, startPos, offsetPercent, end.getX() - start.getX(), end.getZ() - start.getZ(), minX, minZ, maxX, maxZ);
                if (!pointsBack.isEmpty()) {
                    particles.addAll(pointsBack);
                    continue;
                }
                break;
            }
        }
        return particles;
    }

    private static List<Vector3> verticalPoints(Vector3 playerPos, Vector3 startPos, double offsetPercent, double unitX, double unitZ, double minX, double minZ, double maxX, double maxZ) {
        ArrayList<Vector3> points = new ArrayList<Vector3>();
        double x = startPos.getX();
        double y = startPos.getY();
        double z = startPos.getZ();
        double unitOffsetX = unitX * offsetPercent;
        double unitOffsetZ = unitZ * offsetPercent;
        double offsetX = x + unitOffsetX;
        double offsetZ = z + unitOffsetZ;
        Vector3 start = Vector3.of((double)offsetX, (double)(y - offsetPercent), (double)offsetZ);
        if (!(offsetX >= minX && offsetX <= maxX && offsetZ >= minZ && offsetZ <= maxZ)) {
            return points;
        }
        if (playerPos.distanceSquared(start) > (double)maxDistanceSquared) {
            return points;
        }
        points.add(start);
        double dy = 0.0;
        while (true) {
            boolean downInsideDistance;
            double up = y + dy;
            double down = y - dy;
            Vector3 upPos = Vector3.of((double)offsetX, (double)(up - offsetPercent), (double)offsetZ);
            Vector3 downPos = Vector3.of((double)offsetX, (double)(down - offsetPercent), (double)offsetZ);
            boolean upInsideDistance = playerPos.distanceSquared(upPos) <= (double)maxDistanceSquared;
            boolean bl = downInsideDistance = playerPos.distanceSquared(downPos) <= (double)maxDistanceSquared;
            if (!upInsideDistance && !downInsideDistance) break;
            if (upInsideDistance) {
                points.add(upPos);
            }
            if (downInsideDistance) {
                points.add(downPos);
            }
            dy += 1.0;
        }
        return points;
    }
}

