/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunkyborder.BorderData;
import org.popcraft.chunkyborder.ChunkyBorder;
import org.popcraft.chunkyborder.event.border.BorderChangeEvent;

public class RemoveCommand
implements ChunkyCommand {
    private final ChunkyBorder chunkyBorder;

    public RemoveCommand(ChunkyBorder chunkyBorder) {
        this.chunkyBorder = chunkyBorder;
    }

    public void execute(Sender sender, CommandArguments arguments) {
        Selection selection;
        World world;
        Map<String, BorderData> borders;
        BorderData currentBorder;
        if (arguments.size() > 1) {
            Chunky chunky = this.chunkyBorder.getChunky();
            Optional world2 = arguments.next().flatMap(arg -> Input.tryWorld((Chunky)chunky, (String)arg));
            if (world2.isPresent()) {
                chunky.getSelection().world((World)world2.get());
            } else {
                sender.sendMessage("help_border", new Object[0]);
                return;
            }
        }
        if ((currentBorder = (borders = this.chunkyBorder.getBorders()).get((world = (selection = this.chunkyBorder.getChunky().getSelection().build()).world()).getName())) != null) {
            borders.remove(world.getName());
            this.chunkyBorder.getMapIntegrations().forEach(mapIntegration -> mapIntegration.removeShapeMarker(world));
            sender.sendMessagePrefixed("format_border_remove", new Object[]{world.getName()});
            this.chunkyBorder.saveBorders();
        } else {
            sender.sendMessagePrefixed("format_border_no_border", new Object[]{world.getName()});
        }
        this.chunkyBorder.getChunky().getEventBus().call((Object)new BorderChangeEvent(world, null));
    }

    public List<String> suggestions(CommandArguments commandArguments) {
        if (commandArguments.size() == 2) {
            ArrayList<String> suggestions = new ArrayList<String>();
            this.chunkyBorder.getChunky().getServer().getWorlds().forEach(world -> suggestions.add(world.getName()));
            return suggestions;
        }
        return List.of();
    }
}

