/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunkyborder.ChunkyBorder;
import org.popcraft.chunkyborder.command.AddCommand;
import org.popcraft.chunkyborder.command.BypassCommand;
import org.popcraft.chunkyborder.command.HelpCommand;
import org.popcraft.chunkyborder.command.ListCommand;
import org.popcraft.chunkyborder.command.LoadCommand;
import org.popcraft.chunkyborder.command.RemoveCommand;
import org.popcraft.chunkyborder.command.WrapCommand;

public class BorderCommand
implements ChunkyCommand {
    private final Map<String, ChunkyCommand> subCommands = new HashMap<String, ChunkyCommand>();

    public BorderCommand(ChunkyBorder chunkyBorder) {
        this.subCommands.put("add", new AddCommand(chunkyBorder));
        this.subCommands.put("bypass", new BypassCommand(chunkyBorder));
        this.subCommands.put("help", new HelpCommand(chunkyBorder));
        this.subCommands.put("list", new ListCommand(chunkyBorder));
        this.subCommands.put("load", new LoadCommand(chunkyBorder));
        this.subCommands.put("remove", new RemoveCommand(chunkyBorder));
        this.subCommands.put("wrap", new WrapCommand(chunkyBorder));
    }

    public void execute(Sender sender, CommandArguments arguments) {
        ChunkyCommand subCommand = arguments.next().map(String::toLowerCase).map(this.subCommands::get).orElse(null);
        if (subCommand == null) {
            this.subCommands.get("help").execute(sender, CommandArguments.empty());
            return;
        }
        subCommand.execute(sender, arguments);
    }

    public List<String> suggestions(CommandArguments arguments) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (arguments.size() == 1) {
            suggestions.addAll(this.subCommands.keySet());
        } else if (arguments.size() > 1) {
            arguments.next().map(String::toLowerCase).map(this.subCommands::get).ifPresent(subCommand -> suggestions.addAll(subCommand.suggestions(arguments)));
        }
        return suggestions;
    }
}

