/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.shape.ShapeFactory;
import org.popcraft.chunky.shape.ShapeType;
import org.popcraft.chunky.util.Formatting;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunkyborder.BorderData;
import org.popcraft.chunkyborder.ChunkyBorder;
import org.popcraft.chunkyborder.event.border.BorderChangeEvent;

public class AddCommand
implements ChunkyCommand {
    private final ChunkyBorder chunkyBorder;

    public AddCommand(ChunkyBorder chunkyBorder) {
        this.chunkyBorder = chunkyBorder;
    }

    public void execute(Sender sender, CommandArguments arguments) {
        Chunky chunky = this.chunkyBorder.getChunky();
        if (arguments.size() > 1) {
            Optional world = arguments.next().flatMap(arg -> Input.tryWorld((Chunky)chunky, (String)arg));
            if (world.isPresent()) {
                chunky.getSelection().world((World)world.get());
            } else {
                sender.sendMessage("help_border", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 2) {
            Optional shape = arguments.next().flatMap(Input::tryShape);
            if (shape.isPresent()) {
                chunky.getSelection().shape((String)shape.get());
            } else {
                sender.sendMessage("help_border", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 3) {
            Optional<Double> centerX = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(c -> !Input.isPastWorldLimit((double)c));
            Optional<Double> centerZ = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(c -> !Input.isPastWorldLimit((double)c));
            if (centerX.isPresent() && centerZ.isPresent()) {
                chunky.getSelection().center(centerX.get().doubleValue(), centerZ.get().doubleValue());
            } else {
                sender.sendMessage("help_border", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 5) {
            Optional<Double> radiusX = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(r -> r >= 0.0 && !Input.isPastWorldLimit((double)r));
            if (radiusX.isPresent()) {
                chunky.getSelection().radius(radiusX.get().doubleValue());
            } else {
                sender.sendMessage("help_border", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 6) {
            Optional<Double> radiusZ = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(r -> r >= 0.0 && !Input.isPastWorldLimit((double)r));
            if (radiusZ.isPresent()) {
                chunky.getSelection().radiusZ(radiusZ.get().doubleValue());
            } else {
                sender.sendMessage("help_border", new Object[0]);
                return;
            }
        }
        Selection selection = chunky.getSelection().build();
        World world = selection.world();
        BorderData borderData = new BorderData(selection);
        Map<String, BorderData> borders = this.chunkyBorder.getBorders();
        BorderData currentBorder = borders.get(world.getName());
        if (currentBorder != null) {
            borderData.setWrap(currentBorder.getWrap());
        }
        borders.put(world.getName(), borderData);
        this.chunkyBorder.getMapIntegrations().forEach(mapIntegration -> mapIntegration.addShapeMarker(world, borderData.getBorder()));
        sender.sendMessagePrefixed("format_border_add", new Object[]{selection.shape(), world.getName(), Formatting.number((double)selection.centerX()), Formatting.number((double)selection.centerZ()), Formatting.radius((Selection)selection)});
        this.chunkyBorder.saveBorders();
        this.chunkyBorder.getChunky().getEventBus().call((Object)new BorderChangeEvent(world, ShapeFactory.getShape((Selection)selection, (boolean)false)));
    }

    public List<String> suggestions(CommandArguments commandArguments) {
        if (commandArguments.size() == 2) {
            ArrayList<String> suggestions = new ArrayList<String>();
            this.chunkyBorder.getChunky().getServer().getWorlds().forEach(world -> suggestions.add(world.getName()));
            return suggestions;
        }
        if (commandArguments.size() == 3) {
            return ShapeType.all();
        }
        return List.of();
    }
}

