/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.joml.Vector3f;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.ChunkyProvider;
import org.popcraft.chunky.platform.NeoForgePlayer;
import org.popcraft.chunky.platform.NeoForgeWorld;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.platform.util.Vector3;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.util.Translator;
import org.popcraft.chunkyborder.BorderCheckTask;
import org.popcraft.chunkyborder.BorderData;
import org.popcraft.chunkyborder.BorderInitializationTask;
import org.popcraft.chunkyborder.ChunkyBorder;
import org.popcraft.chunkyborder.NeoForgeConfig;
import org.popcraft.chunkyborder.NeoForgeMapIntegrationLoader;
import org.popcraft.chunkyborder.command.BorderCommand;
import org.popcraft.chunkyborder.integration.DynmapCommonAPIProvider;
import org.popcraft.chunkyborder.packet.BorderPayload;
import org.popcraft.chunkyborder.platform.Config;
import org.popcraft.chunkyborder.shape.BorderShape;
import org.popcraft.chunkyborder.util.BorderColor;
import org.popcraft.chunkyborder.util.ClientBorder;
import org.popcraft.chunkyborder.util.Particles;

@Mod(value="chunkyborder")
public class ChunkyBorderNeoForge {
    public static final String MOD_ID = "chunkyborder";
    private static final Map<ResourceLocation, BorderShape> borderShapes = new ConcurrentHashMap<ResourceLocation, BorderShape>();
    private static Config config;
    private ChunkyBorder chunkyBorder;
    private BorderCheckTask borderCheckTask;
    private boolean initialized;

    public ChunkyBorderNeoForge(IEventBus modBus) {
        try {
            Class.forName("org.dynmap.DynmapCommonAPI");
            new DynmapCommonAPIProvider();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        NeoForge.EVENT_BUS.register((Object)this);
        modBus.addListener(event -> event.registrar(String.valueOf(0)).optional().playToClient(BorderPayload.ID, CustomPacketPayload.codec(BorderPayload::write, BorderPayload::new), (borderPayload, context) -> {
            ClientBorder clientBorder = borderPayload.getBorder();
            if (clientBorder.worldKey() == null) {
                return;
            }
            ResourceLocation identifier = ResourceLocation.tryParse((String)clientBorder.worldKey());
            if (identifier == null) {
                return;
            }
            BorderShape borderShape = clientBorder.borderShape();
            if (borderShape == null) {
                borderShapes.remove(identifier);
            } else {
                borderShapes.put(identifier, borderShape);
            }
        }));
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        Chunky chunky = ChunkyProvider.get();
        Path configPath = FMLPaths.CONFIGDIR.get().resolve("chunkyborder/config.json");
        NeoForgeConfig config = new NeoForgeConfig(configPath);
        NeoForgeMapIntegrationLoader mapIntegrationLoader = new NeoForgeMapIntegrationLoader();
        this.chunkyBorder = new ChunkyBorder(chunky, config, mapIntegrationLoader);
        Translator.addCustomTranslation((String)"custom_border_message", (String)config.message());
        BorderColor.parseColor(config.visualizerColor());
        new BorderInitializationTask(this.chunkyBorder).run();
        this.borderCheckTask = new BorderCheckTask(this.chunkyBorder);
        this.chunkyBorder.getChunky().getCommands().put("border", new BorderCommand(this.chunkyBorder));
        this.initialized = true;
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        for (World world : this.chunkyBorder.getChunky().getServer().getWorlds()) {
            Shape shape = this.chunkyBorder.getBorder(world.getName()).map(BorderData::getBorder).orElse(null);
            this.sendBorderPacket(List.of(player), world, shape);
        }
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        this.chunkyBorder.disable();
    }

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        boolean visualizerEnabled;
        long checkInterval;
        if (!this.initialized) {
            return;
        }
        MinecraftServer server = event.getServer();
        long tick = server.getTickCount();
        if (tick % (checkInterval = Math.max(1L, this.chunkyBorder.getConfig().checkInterval())) == 0L) {
            this.borderCheckTask.run();
        }
        if (!(visualizerEnabled = this.chunkyBorder.getConfig().visualizerEnabled())) {
            return;
        }
        int maxRange = this.chunkyBorder.getConfig().visualizerRange();
        Particles.setMaxDistance(maxRange);
        server.getPlayerList().getPlayers().forEach(neoForgePlayer -> {
            ServerLevel serverLevel = neoForgePlayer.serverLevel();
            NeoForgeWorld world = new NeoForgeWorld(serverLevel);
            NeoForgePlayer player = new NeoForgePlayer(neoForgePlayer);
            Shape border = this.chunkyBorder.getBorder(world.getName()).map(BorderData::getBorder).orElse(null);
            boolean isUsingMod = this.chunkyBorder.getPlayerData(player.getUUID()).isUsingMod();
            if (border != null && !isUsingMod) {
                List<Vector3> particleLocations = Particles.at((Player)player, border, (double)(tick % 20L) / 20.0);
                Vector3f visualizerColor = new Vector3f(BorderColor.getRGB());
                for (Vector3 location : particleLocations) {
                    BlockPos pos = BlockPos.containing((double)location.getX(), (double)location.getY(), (double)location.getZ());
                    boolean fullyOccluded = serverLevel.getBlockState(pos).isSolidRender((BlockGetter)serverLevel, pos) && serverLevel.getBlockState(pos.north()).isSolidRender((BlockGetter)serverLevel, pos.north()) && serverLevel.getBlockState(pos.east()).isSolidRender((BlockGetter)serverLevel, pos.east()) && serverLevel.getBlockState(pos.south()).isSolidRender((BlockGetter)serverLevel, pos.south()) && serverLevel.getBlockState(pos.west()).isSolidRender((BlockGetter)serverLevel, pos.west());
                    if (fullyOccluded) continue;
                    serverLevel.sendParticles(neoForgePlayer, (ParticleOptions)new DustParticleOptions(visualizerColor, 1.0f), false, location.getX(), location.getY(), location.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        });
    }

    private void sendBorderPacket(Collection<ServerPlayer> players, World world, Shape shape) {
        for (ServerPlayer player : players) {
            if (!player.connection.hasChannel(BorderPayload.ID)) continue;
            player.connection.send((Packet)new ClientboundCustomPayloadPacket((CustomPacketPayload)new BorderPayload(world, shape)));
        }
    }

    public static BorderShape getBorderShape(ResourceLocation identifier) {
        return borderShapes.get(identifier);
    }

    public static Config getConfig() {
        return config;
    }

    public static void setConfig(Config config) {
        ChunkyBorderNeoForge.config = config;
    }
}

