/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder;

import java.util.List;
import org.popcraft.chunkyborder.ChunkyBorder;
import org.popcraft.chunkyborder.integration.MapIntegration;
import org.popcraft.chunkyborder.platform.MapIntegrationLoader;

public class BorderInitializationTask
implements Runnable {
    private final ChunkyBorder chunkyBorder;

    public BorderInitializationTask(ChunkyBorder chunkyBorder) {
        this.chunkyBorder = chunkyBorder;
    }

    @Override
    public void run() {
        String label = this.chunkyBorder.getConfig().label();
        String color = this.chunkyBorder.getConfig().color();
        boolean hideByDefault = this.chunkyBorder.getConfig().hideByDefault();
        int priority = this.chunkyBorder.getConfig().priority();
        int weight = this.chunkyBorder.getConfig().weight();
        MapIntegrationLoader mapIntegrationLoader = this.chunkyBorder.getMapIntegrationLoader();
        List<MapIntegration> mapIntegrations = this.chunkyBorder.getMapIntegrations();
        if (this.chunkyBorder.getConfig().blueMapEnabled()) {
            mapIntegrationLoader.loadBlueMap().ifPresent(mapIntegrations::add);
        }
        if (this.chunkyBorder.getConfig().dynmapEnabled()) {
            mapIntegrationLoader.loadDynmap().ifPresent(mapIntegrations::add);
        }
        if (this.chunkyBorder.getConfig().pl3xmapEnabled()) {
            mapIntegrationLoader.loadPl3xMap().ifPresent(mapIntegrations::add);
        }
        if (this.chunkyBorder.getConfig().squaremapEnabled()) {
            mapIntegrationLoader.loadSquaremap().ifPresent(mapIntegrations::add);
        }
        for (MapIntegration mapIntegration : mapIntegrations) {
            mapIntegration.setOptions(label, color, hideByDefault, priority, weight);
        }
        this.chunkyBorder.addBorders();
    }
}

