/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunkyborder;

import java.io.Serializable;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.shape.ShapeFactory;
import org.popcraft.chunkyborder.BorderWrapType;

public class BorderData
implements Serializable {
    private String world;
    private double centerX;
    private double centerZ;
    private double radiusX;
    private double radiusZ;
    private String shape;
    private String wrap;
    private transient Shape border;

    public BorderData() {
    }

    public BorderData(Selection selection) {
        this.world = selection.world().getName();
        this.centerX = selection.centerX();
        this.centerZ = selection.centerZ();
        this.radiusX = selection.radiusX();
        this.radiusZ = selection.radiusZ();
        this.shape = selection.shape();
    }

    public String getWorld() {
        return this.world;
    }

    public void setWorld(String world) {
        this.world = world;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = centerX;
    }

    public double getCenterZ() {
        return this.centerZ;
    }

    public void setCenterZ(double centerZ) {
        this.centerZ = centerZ;
    }

    public double getRadiusX() {
        return this.radiusX;
    }

    public void setRadiusX(double radiusX) {
        this.radiusX = radiusX;
    }

    public double getRadiusZ() {
        return this.radiusZ;
    }

    public void setRadiusZ(double radiusZ) {
        this.radiusZ = radiusZ;
    }

    public String getShape() {
        return this.shape;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    public String getWrap() {
        return BorderWrapType.fromString(this.wrap).name().toLowerCase();
    }

    public void setWrap(String wrap) {
        this.wrap = BorderWrapType.fromString(wrap).name().toLowerCase();
    }

    public BorderWrapType getWrapType() {
        return BorderWrapType.fromString(this.getWrap());
    }

    public Shape getBorder() {
        if (this.border == null) {
            this.border = ShapeFactory.getShape((Selection)this.asSelection().build(), (boolean)false);
            this.shape = this.border.name();
            this.wrap = BorderWrapType.fromString(this.wrap).name().toLowerCase();
        }
        return this.border;
    }

    public void setBorder(Shape border) {
        this.border = border;
    }

    public Selection.Builder asSelection() {
        return Selection.builder(null, null).center(this.centerX, this.centerZ).radiusX(this.radiusX).radiusZ(this.radiusZ).shape(this.shape);
    }
}

