/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.List;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.util.Formatting;
import org.popcraft.chunky.util.Input;

public class CornersCommand
implements ChunkyCommand {
    private final Chunky chunky;

    public CornersCommand(Chunky chunky) {
        this.chunky = chunky;
    }

    @Override
    public void execute(Sender sender, CommandArguments arguments) {
        String shape;
        Optional x1 = arguments.next().flatMap(Input::tryDoubleSuffixed);
        Optional z1 = arguments.next().flatMap(Input::tryDoubleSuffixed);
        Optional x2 = arguments.next().flatMap(Input::tryDoubleSuffixed);
        Optional z2 = arguments.next().flatMap(Input::tryDoubleSuffixed);
        if (x1.isEmpty() || z1.isEmpty() || x2.isEmpty() || z2.isEmpty()) {
            sender.sendMessage("help_corners", new Object[0]);
            return;
        }
        if (Input.isPastWorldLimit((Double)x1.get()) || Input.isPastWorldLimit((Double)z1.get()) || Input.isPastWorldLimit((Double)x2.get()) || Input.isPastWorldLimit((Double)z2.get())) {
            sender.sendMessage("help_corners", new Object[0]);
            return;
        }
        double centerX = ((Double)x1.get() + (Double)x2.get()) / 2.0;
        double centerZ = ((Double)z1.get() + (Double)z2.get()) / 2.0;
        double radiusX = Math.abs((Double)x1.get() - (Double)x2.get()) / 2.0;
        double radiusZ = Math.abs((Double)z1.get() - (Double)z2.get()) / 2.0;
        this.chunky.getSelection().center(centerX, centerZ).radiusX(radiusX).radiusZ(radiusZ);
        sender.sendMessagePrefixed("format_center", Formatting.number(centerX), Formatting.number(centerZ));
        if (radiusX == radiusZ) {
            sender.sendMessagePrefixed("format_radius", Formatting.number(radiusX));
            shape = "square";
        } else {
            sender.sendMessagePrefixed("format_radii", Formatting.number(radiusX), Formatting.number(radiusZ));
            shape = "rectangle";
        }
        this.chunky.getSelection().shape(shape);
        sender.sendMessagePrefixed("format_shape", shape);
    }

    @Override
    public List<String> suggestions(CommandArguments arguments) {
        return List.of();
    }
}

