/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.picture;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import javax.imageio.ImageIO;
import me.chrr.camerapture.ByteCollector;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.config.Config;
import me.chrr.camerapture.item.CameraItem;
import me.chrr.camerapture.net.serverbound.NewPicturePacket;
import me.chrr.camerapture.net.serverbound.UploadPartialPicturePacket;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.util.ImageUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class PictureTaker {
    private static final PictureTaker INSTANCE = new PictureTaker();
    public float zoomLevel = 1.0f;
    private boolean hudWasHidden = false;
    private boolean takingPicture = false;
    private BufferedImage picture;
    private int maxImageBytes;
    private int maxImageResolution;

    private PictureTaker() {
    }

    public void takePicture() {
        if (this.takingPicture) {
            return;
        }
        this.takingPicture = true;
        this.hudWasHidden = Minecraft.getInstance().options.hideGui;
        Minecraft.getInstance().options.hideGui = true;
    }

    public void tryUploadFile(Path filePath) {
        block2: {
            try {
                this.picture = ImageIO.read(filePath.toFile());
                Camerapture.NETWORK.sendToServer(new NewPicturePacket());
            }
            catch (IOException e) {
                Camerapture.LOGGER.error("failed to read picture from file", (Throwable)e);
                LocalPlayer player = Minecraft.getInstance().player;
                if (player == null) break block2;
                player.displayClientMessage((Component)Component.translatable((String)"text.camerapture.upload_failed").withStyle(ChatFormatting.RED), false);
            }
        }
    }

    public void renderTickEnd() {
        if (!this.takingPicture) {
            return;
        }
        Minecraft client = Minecraft.getInstance();
        this.takingPicture = false;
        client.options.hideGui = this.hudWasHidden;
        try (NativeImage nativeImage = Screenshot.takeScreenshot((RenderTarget)client.getMainRenderTarget());){
            this.picture = ImageUtil.fromNativeImage(nativeImage, false);
        }
        CameraItem.HeldCamera activeCamera = CameraItem.find((Player)client.player, true);
        if (activeCamera != null) {
            CameraItem.setActive(activeCamera.stack(), false);
        }
        Camerapture.NETWORK.sendToServer(new NewPicturePacket());
    }

    public void uploadStoredPicture(UUID pictureId) {
        block5: {
            if (this.picture == null) {
                return;
            }
            try {
                BufferedImage picture = ImageUtil.clampSize(this.picture, this.maxImageResolution);
                float factor = 1.0f;
                byte[] bytes = ImageUtil.compressIntoWebP(picture, factor);
                while (bytes.length > this.maxImageBytes) {
                    if (factor < 0.1f) {
                        throw new IOException("image too big, even at 10% compression (" + bytes.length + " bytes)");
                    }
                    bytes = ImageUtil.compressIntoWebP(picture, factor -= 0.05f);
                }
                Camerapture.LOGGER.debug("sending picture ({} bytes, {}%)", (Object)bytes.length, (Object)((int)(factor * 100.0f)));
                ByteCollector.split(bytes, 30000, (section, bytesLeft) -> Camerapture.NETWORK.sendToServer(new UploadPartialPicturePacket(pictureId, section, bytesLeft)));
                ClientPictureStore.getInstance().processReceivedImage(pictureId, picture);
                ClientPictureStore.getInstance().cacheBytesToDisk(pictureId, bytes);
                this.picture = null;
            }
            catch (IOException e) {
                Camerapture.LOGGER.error("failed to send picture to server", (Throwable)e);
                this.picture = null;
                LocalPlayer player = Minecraft.getInstance().player;
                if (player == null) break block5;
                player.displayClientMessage((Component)Component.translatable((String)"text.camerapture.upload_failed").withStyle(ChatFormatting.RED), false);
            }
        }
    }

    public void configureFromConfig() {
        Config config = Camerapture.CONFIG_MANAGER.getConfig();
        this.maxImageBytes = config.server.maxImageBytes;
        this.maxImageResolution = config.server.maxImageResolution;
    }

    public void configure(int maxImageBytes, int maxImageResolution) {
        Camerapture.LOGGER.info("setting max image size to {} bytes, max resolution to {}", (Object)maxImageBytes, (Object)maxImageResolution);
        this.maxImageBytes = maxImageBytes;
        this.maxImageResolution = maxImageResolution;
    }

    public void zoom(float delta) {
        this.zoomLevel += delta;
        this.zoomLevel = Math.max(1.0f, Math.min(6.0f, this.zoomLevel));
    }

    public float getFovModifier() {
        float zoomProgress = 1.0f - (this.zoomLevel - 1.0f) / 5.0f;
        return 0.1f + 0.9f * (float)Math.pow(zoomProgress, 2.0);
    }

    public static PictureTaker getInstance() {
        return INSTANCE;
    }
}

