/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.item;

import me.chrr.camerapture.Camerapture;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CameraItem
extends Item {
    public static final ResourceLocation ID = Camerapture.id("camera");
    public static final ResourceKey<Item> KEY = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ID);
    public static boolean allowUploading = false;

    public CameraItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        boolean active = CameraItem.isActive(stack);
        if (active || !player.isShiftKeyDown()) {
            CameraItem.setActive(stack, !active);
            return InteractionResultHolder.consume((Object)stack);
        }
        if (!allowUploading && player.isShiftKeyDown()) {
            player.displayClientMessage((Component)Component.translatable((String)"text.camerapture.uploading_disabled").withStyle(ChatFormatting.RED), true);
            return InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!selected) {
            CameraItem.setActive(stack, false);
        }
    }

    public static void setActive(ItemStack stack, boolean active) {
        stack.set(Camerapture.CAMERA_ACTIVE, (Object)active);
    }

    public static boolean isActive(ItemStack stack) {
        return stack.get(Camerapture.CAMERA_ACTIVE) == Boolean.TRUE;
    }

    public static int getPaperInInventory(Player player) {
        return player.getInventory().countItem(Items.PAPER);
    }

    public static boolean canTakePicture(Player player) {
        return player.hasInfiniteMaterials() || CameraItem.getPaperInInventory(player) > 0;
    }

    @Nullable
    public static HeldCamera find(Player player, boolean shouldBeActive) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(hand);
            if (shouldBeActive && !CameraItem.isActive(stack)) continue;
            return new HeldCamera(stack, hand);
        }
        return null;
    }

    public record HeldCamera(ItemStack stack, InteractionHand hand) {
    }
}

