/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.gui;

import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.gui.PictureSlot;
import me.chrr.camerapture.item.AlbumItem;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class AlbumScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;

    public AlbumScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(AlbumItem.SLOTS));
    }

    public AlbumScreenHandler(int syncId, Inventory playerInventory, Container inventory) {
        super(Camerapture.ALBUM_SCREEN_HANDLER, syncId);
        int x;
        AlbumScreenHandler.checkContainerSize((Container)inventory, (int)AlbumItem.SLOTS);
        this.inventory = inventory;
        inventory.startOpen(playerInventory.player);
        for (int page = 0; page < AlbumItem.PAGES; ++page) {
            for (int side = 0; side < 2; ++side) {
                for (int y = 0; y < 3; ++y) {
                    for (int x2 = 0; x2 < 2; ++x2) {
                        int i = page * 12 + side * 6 + y * 2 + x2;
                        int dx = side * 131 + 22 + x2 * 56;
                        int dy = 27 + y * 32;
                        this.addSlot(new PictureSlot(inventory, i, dx, dy));
                    }
                }
            }
        }
        for (x = 0; x < 9; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.addSlot(new Slot((Container)playerInventory, 9 + y * 9 + x, 60 + x * 18, 155 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInventory, x, 60 + x * 18, 213));
        }
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int slotId) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotId);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemStack = stack.copy();
            if (slotId < AlbumItem.SLOTS ? !this.moveItemStackTo(stack, AlbumItem.SLOTS, AlbumItem.SLOTS + 36, true) : !this.tryAddPicture(stack)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return itemStack;
    }

    private boolean tryAddPicture(ItemStack stack) {
        if (!stack.is(Camerapture.PICTURE)) {
            return false;
        }
        for (int i = 0; i < AlbumItem.SLOTS; ++i) {
            Slot slot = this.getSlot(i);
            if (slot.hasItem()) continue;
            ItemStack picture = stack.split(1);
            slot.setByPlayer(picture);
            return true;
        }
        return false;
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }
}

