/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.gui.AlbumScreenHandler;
import me.chrr.camerapture.gui.PictureSlot;
import me.chrr.camerapture.item.AlbumItem;
import me.chrr.camerapture.item.PictureItem;
import me.chrr.camerapture.picture.ClientPictureStore;
import me.chrr.camerapture.picture.RemotePicture;
import me.chrr.camerapture.util.PictureDrawingUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class AlbumScreen
extends AbstractContainerScreen<AlbumScreenHandler> {
    private static final ResourceLocation TEXTURE = Camerapture.id("textures/gui/edit_album.png");
    private int activePage = 0;
    private Component pageText = Component.empty();
    private PageButton previousButton;
    private PageButton nextButton;

    public AlbumScreen(AlbumScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.imageWidth = 280;
        this.imageHeight = 237;
        this.inventoryLabelX = 60;
        this.inventoryLabelY = this.imageHeight - 94;
        this.titleLabelX = 19;
        this.titleLabelY = 15;
    }

    protected void init() {
        super.init();
        this.previousButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.leftPos + 22, this.topPos + 121, false, button -> this.changePage(-1), true));
        this.nextButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(this.leftPos + 234, this.topPos + 121, true, button -> this.changePage(1), true));
        this.updatePage();
    }

    private void changePage(int delta) {
        this.activePage = Math.min(Math.max(this.activePage + delta, 0), AlbumItem.PAGES);
        this.updatePage();
    }

    private void updatePage() {
        for (int i = 0; i < AlbumItem.SLOTS; ++i) {
            int page = i / AlbumItem.ITEMS_PER_PAGE;
            ((PictureSlot)((Object)((AlbumScreenHandler)this.menu).slots.get(i))).setEnabled(page == this.activePage);
        }
        this.pageText = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{this.activePage + 1, AlbumItem.PAGES});
        this.previousButton.visible = this.activePage != 0;
        this.nextButton.visible = this.activePage != AlbumItem.PAGES - 1;
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        context.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 512);
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        context.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0, false);
        context.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
        int textWidth = this.font.width((FormattedText)this.pageText);
        int pageX = this.imageWidth - this.titleLabelX - textWidth;
        context.drawString(this.font, this.pageText, pageX, this.titleLabelY, 0, false);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int left, int top, int button) {
        int xOffset = mouseY - (double)top > 148.0 ? 52 : 0;
        return mouseX < (double)(left + xOffset) || mouseY < (double)top || mouseX >= (double)(left + this.imageWidth - xOffset) || mouseY >= (double)(top + this.imageHeight);
    }

    protected void renderSlot(GuiGraphics context, Slot slot) {
        if (!(slot instanceof PictureSlot)) {
            super.renderSlot(context, slot);
            return;
        }
        PictureSlot pictureSlot = (PictureSlot)slot;
        RenderSystem.enableBlend();
        if (pictureSlot.hasItem()) {
            PictureItem.PictureData pictureData = PictureItem.getPictureData(slot.getItem());
            if (pictureData != null) {
                RemotePicture picture = ClientPictureStore.getInstance().ensureRemotePicture(pictureData.id());
                PictureDrawingUtil.drawPicture(context, this.font, picture, slot.x, slot.y, pictureSlot.getWidth(), pictureSlot.getHeight());
            }
        } else {
            context.blit(TEXTURE, slot.x - 1, slot.y - 1, 280.0f, 0.0f, pictureSlot.getWidth() + 2, pictureSlot.getHeight() + 2, 512, 512);
        }
        RenderSystem.disableBlend();
    }
}

