/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.config.Config;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Config config = new Config();

    public Config getConfig() {
        return this.config;
    }

    public void load() {
        Path clientPath = this.getPath("client");
        Path serverPath = this.getPath("server");
        try {
            if (clientPath.toFile().isFile()) {
                this.config.client = (Config.Client)GSON.fromJson(Files.readString(clientPath), Config.Client.class);
                this.config.client.upgrade();
            }
            if (serverPath.toFile().isFile()) {
                this.config.server = (Config.Server)GSON.fromJson(Files.readString(serverPath), Config.Server.class);
                this.config.server.upgrade();
            }
            this.save();
        }
        catch (IOException e) {
            Camerapture.LOGGER.error("failed to load config", (Throwable)e);
        }
    }

    public void save() {
        try {
            if (Camerapture.PLATFORM.isClientSide()) {
                Files.writeString(this.getPath("client"), (CharSequence)GSON.toJson((Object)this.config.client), new OpenOption[0]);
            }
            Files.writeString(this.getPath("server"), (CharSequence)GSON.toJson((Object)this.config.server), new OpenOption[0]);
        }
        catch (IOException e) {
            Camerapture.LOGGER.error("failed to save config", (Throwable)e);
        }
    }

    private Path getPath(String environment) {
        return Camerapture.PLATFORM.getConfigFolder().resolve("camerapture." + environment + ".json");
    }
}

