/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class Shapes {
    @Deprecated
    public static Map<Direction, VoxelShape> buildShapeRotations(int x0, int y0, int z0, int x1, int y1, int z1) {
        return Shapes.buildShapeRotationsFromNorth(z0, y0, 16 - x1, z1, y1, 16 - x0);
    }

    public static Map<Direction, VoxelShape> buildShapeRotationsFromNorth(int x0, int y0, int z0, int x1, int y1, int z1) {
        EnumMap<Direction, VoxelShape> result = new EnumMap<Direction, VoxelShape>(Direction.class);
        result.put(Direction.NORTH, Block.box((double)x0, (double)y0, (double)z0, (double)x1, (double)y1, (double)z1));
        result.put(Direction.SOUTH, Block.box((double)(16.0 - (double)x1), (double)y0, (double)(16.0 - (double)z1), (double)(16.0 - (double)x0), (double)y1, (double)(16.0 - (double)z0)));
        result.put(Direction.EAST, Block.box((double)(16.0 - (double)z1), (double)y0, (double)x0, (double)(16.0 - (double)z0), (double)y1, (double)x1));
        result.put(Direction.WEST, Block.box((double)z0, (double)y0, (double)(16.0 - (double)x1), (double)z1, (double)y1, (double)(16.0 - (double)x0)));
        return result;
    }

    @SafeVarargs
    public static Map<Direction, VoxelShape> mergeShapeMaps(Map<Direction, VoxelShape> ... maps) {
        return new EnumMap<Direction, VoxelShape>(Direction.Plane.HORIZONTAL.stream().collect(Collectors.toMap(Function.identity(), direction -> Arrays.stream(maps).map(map -> {
            VoxelShape shape = (VoxelShape)map.get(direction);
            if (shape == null) {
                throw new IllegalArgumentException("Map is missing shape for " + String.valueOf(direction));
            }
            return shape;
        }).reduce(net.minecraft.world.phys.shapes.Shapes::or).orElseThrow())));
    }

    public static Map<Direction, VoxelShape> mergeIntoShapeMap(Map<Direction, VoxelShape> map, VoxelShape shape) {
        EnumMap<Direction, VoxelShape> result = new EnumMap<Direction, VoxelShape>(Direction.class);
        map.forEach((direction, existing) -> result.put((Direction)direction, net.minecraft.world.phys.shapes.Shapes.or((VoxelShape)existing, (VoxelShape)shape)));
        return result;
    }
}

