/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import juuxel.adorn.util.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class NbtUtil {
    private static final Logger LOGGER = Logging.logger();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T getWithCodec(CompoundTag nbt, String name, Codec<T> codec, HolderLookup.Provider registries) {
        Object object;
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        Tag subNbt = nbt.get(name);
        if (subNbt == null) {
            return null;
        }
        DataResult dataResult = codec.parse((DynamicOps)ops, (Object)subNbt);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                DataResult.Success success = (DataResult.Success)dataResult2;
                try {
                    Object object2;
                    Object value = object2 = success.value();
                    Object lifecycle = object2 = success.lifecycle();
                    object = value;
                    return (T)object;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        DataResult.Error error = (DataResult.Error)dataResult2;
        LOGGER.error("[Adorn] Could not deserialize {}: {}", (Object)name, (Object)error.message());
        object = null;
        return (T)object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> void putWithCodec(CompoundTag nbt, String name, Codec<T> codec, T value, HolderLookup.Provider registries) {
        DataResult encoded;
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        DataResult dataResult = encoded = codec.encodeStart((DynamicOps)ops, value);
        Objects.requireNonNull(dataResult);
        DataResult dataResult2 = dataResult;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Tag subNbt;
                Tag tag;
                DataResult.Success success = (DataResult.Success)dataResult2;
                try {
                    subNbt = tag = (Tag)success.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                {
                    Tag lifecycle = tag = success.lifecycle();
                }
                nbt.put(name, subNbt);
                return;
            }
            case 1: 
        }
        DataResult.Error error = (DataResult.Error)dataResult2;
        LOGGER.error("[Adorn] Could not serialize {}: {}", (Object)name, (Object)error.message());
    }

    public static void putText(CompoundTag nbt, String name, Component text, HolderLookup.Provider registries) {
        NbtUtil.putWithCodec(nbt, name, ComponentSerialization.CODEC, text, registries);
    }

    @Nullable
    public static Component getText(CompoundTag nbt, String name, HolderLookup.Provider registries) {
        return (Component)NbtUtil.getWithCodec(nbt, name, ComponentSerialization.CODEC, registries);
    }

    public static BlockPos getBlockPos(CompoundTag nbt, String key) {
        int[] coords = nbt.getIntArray(key);
        return new BlockPos(coords[0], coords[1], coords[2]);
    }

    public static void putBlockPos(CompoundTag nbt, String key, BlockPos pos) {
        nbt.putIntArray(key, new int[]{pos.getX(), pos.getY(), pos.getZ()});
    }
}

