/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.recipe;

import juuxel.adorn.component.AdornComponentTypes;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.lib.AdornTags;
import juuxel.adorn.recipe.AdornRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class FertilizerRefillingRecipe
extends CustomRecipe {
    public FertilizerRefillingRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level world) {
        return this.match(input) != null;
    }

    public ItemStack craft(CraftingInput input, HolderLookup.Provider registries) {
        MatchResult match = this.match(input);
        if (match == null) {
            return ItemStack.EMPTY;
        }
        ItemStack result = match.wateringCan().copy();
        int fertilizerLevel = (Integer)result.getOrDefault((DataComponentType)AdornComponentTypes.FERTILIZER_LEVEL.get(), (Object)0);
        int newFertilizerLevel = Math.min(fertilizerLevel + match.fertilizers(), 32);
        result.set((DataComponentType)AdornComponentTypes.FERTILIZER_LEVEL.get(), (Object)newFertilizerLevel);
        return result;
    }

    @Nullable
    private MatchResult match(CraftingInput inventory) {
        ItemStack wateringCan = ItemStack.EMPTY;
        int fertilizers = 0;
        for (int slot = 0; slot < inventory.size(); ++slot) {
            ItemStack stack = inventory.getItem(slot);
            if (stack.is((Item)AdornItems.WATERING_CAN.get())) {
                if (wateringCan.isEmpty()) {
                    wateringCan = stack;
                    continue;
                }
                return null;
            }
            if (stack.isEmpty()) continue;
            if (stack.is(AdornTags.WATERING_CAN_FERTILIZERS)) {
                ++fertilizers;
                continue;
            }
            return null;
        }
        if (wateringCan.isEmpty() || fertilizers == 0) {
            return null;
        }
        return new MatchResult(wateringCan, fertilizers);
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AdornRecipeSerializers.FERTILIZER_REFILLING.get();
    }

    private record MatchResult(ItemStack wateringCan, int fertilizers) {
    }
}

