/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.util;

import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public final class FluidTankReference
extends FluidReference {
    private final FluidTank tank;

    public FluidTankReference(FluidTank tank) {
        this.tank = tank;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public Fluid getFluid() {
        return this.tank.getFluid().getFluid();
    }

    @Override
    public void setFluid(Fluid fluid) {
        this.tank.setFluid(new FluidStack((Holder)fluid.builtInRegistryHolder(), this.tank.getFluid().getAmount(), this.tank.getFluid().getComponentsPatch()));
    }

    @Override
    public long getAmount() {
        return this.tank.getFluid().getAmount();
    }

    @Override
    public void setAmount(long amount) {
        this.tank.getFluid().setAmount((int)amount);
    }

    @Override
    public DataComponentPatch getComponents() {
        return this.tank.getFluid().getComponentsPatch();
    }

    @Override
    public void setComponents(DataComponentPatch changes) {
        this.tank.getFluid().getComponents().restorePatch(changes);
    }

    @Override
    public FluidUnit getUnit() {
        return FluidUnit.LITRE;
    }

    public static FluidStack toFluidStack(FluidReference reference) {
        if (reference instanceof FluidTankReference) {
            FluidTankReference ftr = (FluidTankReference)reference;
            return ftr.tank.getFluid();
        }
        return new FluidStack((Holder)reference.getFluid().builtInRegistryHolder(), (int)reference.getAmount(), reference.getComponents());
    }

    public static FluidVolume toFluidVolume(FluidStack stack) {
        return new FluidVolume(stack.getFluid(), stack.getAmount(), stack.getComponentsPatch(), FluidUnit.LITRE);
    }
}

