/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.event;

import juuxel.adorn.block.SofaBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.CanContinueSleepingEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSetSpawnEvent;

public final class EntityEvents {
    public static void init() {
        NeoForge.EVENT_BUS.addListener(EntityEvents::handleSofaSleepTime);
        NeoForge.EVENT_BUS.addListener(EntityEvents::preventSofaSpawns);
    }

    private static void handleSofaSleepTime(CanContinueSleepingEvent event) {
        BlockPos sleepingPos = event.getEntity().getSleepingPos().orElse(null);
        if (sleepingPos == null) {
            return;
        }
        Level world = event.getEntity().level();
        if (event.getProblem() == Player.BedSleepingProblem.NOT_POSSIBLE_NOW && world.isDay() && world.getBlockState(sleepingPos).getBlock() instanceof SofaBlock) {
            event.setContinueSleeping(true);
        }
    }

    private static void preventSofaSpawns(PlayerSetSpawnEvent event) {
        BlockPos pos = event.getNewSpawn();
        if (pos != null && !event.isForced() && event.getEntity().level().getBlockState(pos).getBlock() instanceof SofaBlock) {
            event.setCanceled(true);
        }
    }
}

