/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.event;

import juuxel.adorn.CommonEventHandlers;
import juuxel.adorn.block.SneakClickHandler;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public final class BlockEvents {
    public static void init() {
        NeoForge.EVENT_BUS.addListener(BlockEvents::handleCarpetedBlocks);
        NeoForge.EVENT_BUS.addListener(BlockEvents::handleSneakClicks);
    }

    private static void handleCarpetedBlocks(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result = CommonEventHandlers.handleCarpets(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
        if (result != InteractionResult.PASS) {
            event.setCancellationResult(result);
            event.setCanceled(true);
        }
    }

    private static void handleSneakClicks(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        BlockState state = event.getLevel().getBlockState(event.getPos());
        Block block = state.getBlock();
        if (block instanceof SneakClickHandler) {
            InteractionResult result;
            SneakClickHandler clickHandler = (SneakClickHandler)block;
            if (player.isShiftKeyDown() && player.getItemInHand(event.getHand()).isEmpty() && (result = clickHandler.onSneakClick(state, event.getLevel(), event.getPos(), player, event.getHand(), event.getHitVec())) != InteractionResult.PASS) {
                event.setCancellationResult(result);
                event.setCanceled(true);
            }
        }
    }
}

