/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.client;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import juuxel.adorn.client.FluidRenderingBridge;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.platform.forge.util.FluidTankReference;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public final class FluidRenderingBridgeForge
implements FluidRenderingBridge {
    public static final FluidRenderingBridgeForge INSTANCE = new FluidRenderingBridgeForge();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public TextureAtlasSprite getStillSprite(FluidReference volume) {
        Fluid fluid = volume.getFluid();
        Function atlas = Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS);
        return (TextureAtlasSprite)atlas.apply(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture(FluidTankReference.toFluidStack(volume)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColor(FluidReference volume, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos) {
        Fluid fluid = volume.getFluid();
        if (world != null && pos != null) {
            return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(fluid.defaultFluidState(), world, pos);
        }
        return IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(FluidTankReference.toFluidStack(volume));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean fillsFromTop(FluidReference volume) {
        Fluid fluid = volume.getFluid();
        return fluid.getFluidType().isLighterThanAir();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getTooltip(FluidReference volume, TooltipFlag type, @Nullable Integer maxAmountInLitres) {
        ArrayList<Component> result = new ArrayList<Component>();
        Fluid fluid = volume.getFluid();
        FluidStack stack = FluidTankReference.toFluidStack(volume);
        Component name = stack.getHoverName();
        result.add((Component)Component.empty().append(name).withStyle(fluid.getFluidType().getRarity(stack).getStyleModifier()));
        if (maxAmountInLitres != null) {
            result.add(volume.getAmountText(maxAmountInLitres.intValue(), FluidUnit.LITRE));
        } else {
            result.add(volume.getAmountText());
        }
        if (type.isAdvanced()) {
            result.add((Component)Component.literal((String)BuiltInRegistries.FLUID.getKey((Object)fluid).toString()).withStyle(ChatFormatting.DARK_GRAY));
        }
        return result;
    }
}

