/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge.block.entity;

import juuxel.adorn.block.entity.BrewerBlockEntity;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.platform.forge.block.entity.BlockEntityWithFluidTank;
import juuxel.adorn.platform.forge.util.FluidTankReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public final class BrewerBlockEntityForge
extends BrewerBlockEntity
implements BlockEntityWithFluidTank {
    private final FluidTank tank = new FluidTank(2000){

        protected void onContentsChanged() {
            BrewerBlockEntityForge.this.setChanged();
        }
    };
    private final FluidReference fluidReference = new FluidTankReference(this.tank);

    public BrewerBlockEntityForge(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public FluidReference getFluidReference() {
        return this.fluidReference;
    }

    @Override
    protected boolean canExtractFluidContainer() {
        return !FluidUtil.tryEmptyContainer((ItemStack)this.getItem(3), (IFluidHandler)this.tank, (int)this.tank.getSpace(), null, (boolean)false).isSuccess();
    }

    @Override
    protected void tryExtractFluidContainer() {
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)this.getItem(3), (IFluidHandler)this.tank, (int)this.tank.getSpace(), null, (boolean)true);
        if (result.isSuccess()) {
            this.setItem(3, result.result);
            this.setChanged();
        }
    }

    @Override
    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        this.tank.writeToNBT(registries, nbt);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.tank.readFromNBT(registries, nbt);
    }
}

