/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.loot;

import com.mojang.serialization.MapCodec;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.component.AdornComponentTypes;
import juuxel.adorn.loot.AdornLootFunctionTypes;
import juuxel.adorn.trading.Trade;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;

public final class CheckTradingStationOwnerLootFunction
implements LootItemFunction {
    public static final CheckTradingStationOwnerLootFunction INSTANCE = new CheckTradingStationOwnerLootFunction();
    public static final MapCodec<CheckTradingStationOwnerLootFunction> CODEC = MapCodec.unit((Object)INSTANCE);

    private CheckTradingStationOwnerLootFunction() {
    }

    public ItemStack apply(ItemStack stack, LootContext lootContext) {
        if (stack.is(((Block)AdornBlocks.TRADING_STATION.get()).asItem()) && !this.hasTrade(stack) && !this.hasStorage(stack)) {
            this.clearOwner(stack);
        }
        return stack;
    }

    private boolean hasTrade(ItemStack stack) {
        Trade trade = (Trade)stack.get((DataComponentType)AdornComponentTypes.TRADE.get());
        return trade != null && !trade.isFullyEmpty();
    }

    private boolean hasStorage(ItemStack stack) {
        ItemContainerContents container = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
        if (container == null) {
            return false;
        }
        return container.nonEmptyStream().findAny().isPresent();
    }

    private void clearOwner(ItemStack stack) {
        stack.remove((DataComponentType)AdornComponentTypes.TRADE_OWNER.get());
    }

    public LootItemFunctionType<? extends LootItemFunction> getType() {
        return (LootItemFunctionType)AdornLootFunctionTypes.CHECK_TRADING_STATION_OWNER.get();
    }
}

