/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.item;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Consumer;
import juuxel.adorn.component.AdornComponentTypes;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.StepMaximum;
import juuxel.adorn.item.ItemWithDescription;
import juuxel.adorn.lib.AdornSounds;
import juuxel.adorn.platform.FluidBridge;
import juuxel.adorn.util.Colors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;

public final class WateringCanItem
extends ItemWithDescription {
    private static final int ITEM_BAR_STEPS = 13;
    private static final int MAX_WATER_LEVEL = 50;
    public static final int MAX_FERTILIZER_LEVEL = 32;
    private static final float WATER_LEVEL_DIVISOR = 0.02f;
    private static final int WATER_LEVELS_PER_BUCKET = 10;
    private static final StepMaximum FLUID_DRAIN_PREDICATE = new StepMaximum(0L, 1000L, 100L, FluidUnit.LITRE);

    public WateringCanItem(Item.Properties settings) {
        super(settings);
    }

    /*
     * Unable to fully structure code
     */
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        block8: {
            stack = user.getItemInHand(hand);
            success = false;
            hitResult = WateringCanItem.getPlayerPOVHitResult((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (hitResult.getType() != HitResult.Type.BLOCK) {
                return InteractionResultHolder.pass((Object)stack);
            }
            waterLevel = (Integer)stack.getOrDefault((DataComponentType)AdornComponentTypes.WATER_LEVEL.get(), (Object)0);
            pos = hitResult.getBlockPos();
            state = world.getBlockState(pos);
            block = state.getBlock();
            if (waterLevel >= 50) break block8;
            if (!(block instanceof BucketPickup)) ** GOTO lbl-1000
            drainable = (BucketPickup)block;
            if (world.getFluidState(pos).is((Fluid)Fluids.WATER)) {
                drained = drainable.pickupBlock(user, (LevelAccessor)world, pos, state);
                drainable.getPickupSound().ifPresent((Consumer<SoundEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$use$0(net.minecraft.world.entity.player.Player net.minecraft.sounds.SoundEvent ), (Lnet/minecraft/sounds/SoundEvent;)V)((Player)user));
                if (drained.is(Items.WATER_BUCKET)) {
                    waterLevel = Math.min(waterLevel + 10, 50);
                    stack.set((DataComponentType)AdornComponentTypes.WATER_LEVEL.get(), (Object)waterLevel);
                    success = true;
                }
            } else if ((drained = FluidBridge.get().drain(world, pos, null, hitResult.getDirection().getOpposite(), (Fluid)Fluids.WATER, WateringCanItem.FLUID_DRAIN_PREDICATE)) != null) {
                amount = FluidUnit.convert(drained.getAmount(), drained.getUnit(), FluidUnit.LITRE);
                levels = (int)(amount / WateringCanItem.FLUID_DRAIN_PREDICATE.getStep());
                waterLevel = Math.min(waterLevel + levels, 50);
                stack.set((DataComponentType)AdornComponentTypes.WATER_LEVEL.get(), (Object)waterLevel);
                success = true;
                user.playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
            }
        }
        if (!success && waterLevel > 0) {
            success = true;
            stack.set((DataComponentType)AdornComponentTypes.WATER_LEVEL.get(), (Object)(--waterLevel));
            world.gameEvent((Entity)user, (Holder)GameEvent.ITEM_INTERACT_FINISH, pos);
            world.playSound(user, pos, (SoundEvent)AdornSounds.ITEM_WATERING_CAN_WATER.get(), SoundSource.PLAYERS);
            user.getCooldowns().addCooldown((Item)this, 10);
            mut = new BlockPos.MutableBlockPos();
            for (xo = -1; xo <= 1; ++xo) {
                for (zo = -1; zo <= 1; ++zo) {
                    mut.set(pos.getX() + xo, pos.getY(), pos.getZ() + zo);
                    this.water(world, (BlockPos)mut, user, stack);
                    if (!(world instanceof ServerLevel)) continue;
                    serverWorld = (ServerLevel)world;
                    WateringCanItem.spawnParticlesAt(serverWorld, (BlockPos)mut, hitResult.getLocation().y);
                }
            }
        }
        return success != false ? InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide()) : InteractionResultHolder.pass((Object)stack);
    }

    private void water(Level world, BlockPos pos, Player player, ItemStack stack) {
        Integer fertilizerLevel = (Integer)stack.getOrDefault((DataComponentType)AdornComponentTypes.FERTILIZER_LEVEL.get(), (Object)0);
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (fertilizerLevel > 0 && world.random.nextInt(9) == 0) {
            BonemealableBlock fertilizable;
            if (block instanceof BonemealableBlock && (fertilizable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)world, pos, state)) {
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    if (fertilizable.isBonemealSuccess(world, world.random, pos, state)) {
                        fertilizable.performBonemeal(serverWorld, world.random, pos, state);
                    }
                }
                world.levelEvent(player, 1505, pos, 5);
            }
            stack.set((DataComponentType)AdornComponentTypes.FERTILIZER_LEVEL.get(), (Object)(fertilizerLevel - 1));
        }
        if (!world.isClientSide) {
            BlockPos downPos;
            BlockState downState;
            if (block instanceof FarmBlock) {
                this.waterFarmlandBlock(world, pos, state);
            } else if (!state.isCollisionShapeFullBlock((BlockGetter)world, pos) && (downState = world.getBlockState(downPos = pos.below())).getBlock() instanceof FarmBlock) {
                this.waterFarmlandBlock(world, downPos, downState);
            }
        }
    }

    private void waterFarmlandBlock(Level world, BlockPos pos, BlockState state) {
        Integer moisture = (Integer)state.getValue((Property)FarmBlock.MOISTURE);
        if (moisture < 7) {
            int moistureChange = world.random.nextIntBetweenInclusive(2, 6);
            int newMoisture = Math.min(moisture + moistureChange, 7);
            world.setBlock(pos, (BlockState)state.setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(newMoisture)), 2);
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        int waterLevel = Mth.clamp((int)((Integer)stack.getOrDefault((DataComponentType)AdornComponentTypes.WATER_LEVEL.get(), (Object)0)), (int)0, (int)50);
        return Mth.lerpInt((float)(0.02f * (float)waterLevel), (int)0, (int)13);
    }

    public int getBarColor(ItemStack stack) {
        float rg = Mth.clampedMap((float)((Integer)stack.getOrDefault((DataComponentType)AdornComponentTypes.FERTILIZER_LEVEL.get(), (Object)0)).intValue(), (float)0.0f, (float)32.0f, (float)0.4f, (float)1.0f);
        return Colors.color(rg, rg, 1.0f);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        int fertilizerLevel = (Integer)stack.getOrDefault((DataComponentType)AdornComponentTypes.FERTILIZER_LEVEL.get(), (Object)0);
        MutableComponent currentLevel = Component.literal((String)Integer.toString(fertilizerLevel)).withStyle(ChatFormatting.DARK_AQUA);
        MutableComponent maxLevel = Component.literal((String)Integer.toString(32)).withStyle(ChatFormatting.DARK_AQUA);
        tooltip.add((Component)Component.translatable((String)"item.adorn.watering_can.fertilizer", (Object[])new Object[]{currentLevel, maxLevel}).withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, type);
    }

    private static void spawnParticlesAt(ServerLevel world, BlockPos pos, double y) {
        double px = (double)pos.getX() + 0.3 + world.random.nextDouble() * 0.4;
        double py = y + 0.1;
        double pz = (double)pos.getZ() + 0.3 + world.random.nextDouble() * 0.4;
        double vx = world.random.nextDouble() * 0.2 - 0.1;
        double vy = 0.1;
        double vz = world.random.nextDouble() * 0.2 - 0.1;
        world.sendParticles((ParticleOptions)ParticleTypes.SPLASH, px, py, pz, 4, vx, vy, vz, 0.5);
    }

    private static /* synthetic */ void lambda$use$0(Player user, SoundEvent sound) {
        user.playSound(sound, 1.0f, 1.0f);
    }
}

