/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.item;

import juuxel.adorn.AdornCommon;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.component.AdornComponentTypes;
import juuxel.adorn.item.AdornBookItem;
import juuxel.adorn.item.DrinkInMugItem;
import juuxel.adorn.item.ItemWithDescription;
import juuxel.adorn.item.VerticallyAttachableBlockItemWithDescription;
import juuxel.adorn.item.WateringCanItem;
import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.lib.registry.Registrar;
import juuxel.adorn.lib.registry.RegistrarFactory;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;

public final class AdornItems {
    public static final Registrar<Item> ITEMS = RegistrarFactory.get().create(Registries.ITEM);
    private static final FoodProperties DRINK_FOOD_COMPONENT = AdornItems.drinkFoodComponentBuilder().build();
    public static final Registered<Item> STONE_ROD = ITEMS.register("stone_rod", () -> new ItemWithDescription(new Item.Properties()));
    public static final Registered<Item> MUG = ITEMS.register("mug", () -> new ItemWithDescription(new Item.Properties().stacksTo(16)));
    public static final Registered<Item> HOT_CHOCOLATE = ITEMS.register("hot_chocolate", () -> new DrinkInMugItem(new Item.Properties().food(DRINK_FOOD_COMPONENT).stacksTo(1)));
    public static final Registered<Item> SWEET_BERRY_JUICE = ITEMS.register("sweet_berry_juice", () -> new DrinkInMugItem(new Item.Properties().food(DRINK_FOOD_COMPONENT).stacksTo(1)));
    public static final Registered<Item> GLOW_BERRY_TEA = ITEMS.register("glow_berry_tea", () -> new DrinkInMugItem(new Item.Properties().food(AdornItems.drinkFoodComponentBuilder().effect(new MobEffectInstance(MobEffects.GLOWING, 400), 1.0f).build()).stacksTo(1)));
    public static final Registered<Item> NETHER_WART_COFFEE = ITEMS.register("nether_wart_coffee", () -> new DrinkInMugItem(new Item.Properties().food(DRINK_FOOD_COMPONENT).stacksTo(1)));
    public static final Registered<Item> STONE_TORCH = ITEMS.register("stone_torch", () -> new VerticallyAttachableBlockItemWithDescription((Block)AdornBlocks.STONE_TORCH_GROUND.get(), (Block)AdornBlocks.STONE_TORCH_WALL.get(), new Item.Properties(), Direction.DOWN));
    public static final Registered<Item> GUIDE_BOOK = ITEMS.register("guide_book", () -> new AdornBookItem(AdornCommon.id("guide"), new Item.Properties().rarity(Rarity.UNCOMMON)));
    public static final Registered<Item> TRADERS_MANUAL = ITEMS.register("traders_manual", () -> new AdornBookItem(AdornCommon.id("traders_manual"), new Item.Properties()));
    public static final Registered<Item> COPPER_NUGGET = ITEMS.register("copper_nugget", () -> new ItemWithDescription(new Item.Properties()));
    public static final Registered<Item> WATERING_CAN = ITEMS.register("watering_can", () -> new WateringCanItem(new Item.Properties().component((DataComponentType)AdornComponentTypes.FERTILIZER_LEVEL.get(), (Object)0).component((DataComponentType)AdornComponentTypes.WATER_LEVEL.get(), (Object)0)));

    private static FoodProperties.Builder drinkFoodComponentBuilder() {
        return new FoodProperties.Builder().nutrition(4).saturationModifier(0.3f).alwaysEdible();
    }

    public static void init() {
    }
}

