/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.item;

import java.util.List;
import juuxel.adorn.client.book.BookManager;
import juuxel.adorn.networking.OpenBookS2CMessage;
import juuxel.adorn.platform.PlatformBridges;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public final class AdornBookItem
extends Item {
    private final ResourceLocation bookId;

    public AdornBookItem(ResourceLocation bookId, Item.Properties settings) {
        super(settings);
        this.bookId = bookId;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!world.isClientSide) {
            PlatformBridges.get().getNetwork().sendToClient(user, new OpenBookS2CMessage(this.bookId));
        }
        user.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)user.getItemInHand(hand), (boolean)world.isClientSide);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        BookManager bookManager = PlatformBridges.get().getResources().getBookManager();
        if (bookManager.contains(this.bookId)) {
            tooltip.add((Component)Component.translatable((String)"book.byAuthor", (Object[])new Object[]{bookManager.get(this.bookId).author()}).withStyle(ChatFormatting.GRAY));
        }
    }
}

