/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.fluid.FluidUnit;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public final class FluidVolume
extends FluidReference {
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidVolume> PACKET_CODEC = StreamCodec.ofMember(FluidReference::write, FluidVolume::load);
    private Fluid fluid;
    private long amount;
    private DataComponentPatch components;
    private final FluidUnit unit;

    public FluidVolume(Fluid fluid, long amount, DataComponentPatch components, FluidUnit unit) {
        this.fluid = fluid;
        this.amount = amount;
        this.components = components;
        this.unit = unit;
    }

    public static FluidVolume empty(FluidUnit unit) {
        return new FluidVolume(Fluids.EMPTY, 0L, DataComponentPatch.EMPTY, unit);
    }

    public static FluidVolume load(RegistryFriendlyByteBuf buf) {
        FluidVolume volume = FluidVolume.empty((FluidUnit)buf.readEnum(FluidUnit.class));
        volume.readWithoutUnit(buf);
        return volume;
    }

    @Override
    public Fluid getFluid() {
        return this.fluid;
    }

    @Override
    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public void setAmount(long amount) {
        this.amount = amount;
    }

    @Override
    public DataComponentPatch getComponents() {
        return this.components;
    }

    @Override
    public void setComponents(DataComponentPatch components) {
        this.components = components;
    }

    @Override
    public FluidUnit getUnit() {
        return this.unit;
    }

    @Override
    public String toString() {
        return "FluidVolume(fluid=%s, amount=%d, components=%s)".formatted(this.fluid, this.amount, this.components);
    }
}

