/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import java.util.Objects;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.fluid.FluidIngredient;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.fluid.HasFluidAmount;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public abstract class FluidReference
implements HasFluidAmount {
    public abstract Fluid getFluid();

    public abstract void setFluid(Fluid var1);

    public abstract void setAmount(long var1);

    public abstract DataComponentPatch getComponents();

    public abstract void setComponents(DataComponentPatch var1);

    public boolean isEmpty() {
        return this.getFluid() == Fluids.EMPTY || this.getAmount() == 0L;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.getUnit());
        if (this.isEmpty()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeVarInt(BuiltInRegistries.FLUID.getId((Object)this.getFluid()));
            buf.writeVarLong(this.getAmount());
            DataComponentPatch.STREAM_CODEC.encode((Object)buf, (Object)this.getComponents());
        }
    }

    protected void readWithoutUnit(RegistryFriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.setFluid((Fluid)BuiltInRegistries.FLUID.byId(buf.readVarInt()));
            this.setAmount(buf.readVarLong());
            this.setComponents((DataComponentPatch)DataComponentPatch.STREAM_CODEC.decode((Object)buf));
        } else {
            this.setFluid(Fluids.EMPTY);
            this.setAmount(0L);
            this.setComponents(DataComponentPatch.EMPTY);
        }
    }

    public FluidVolume createSnapshot() {
        return new FluidVolume(this.getFluid(), this.getAmount(), this.getComponents(), this.getUnit());
    }

    public void increment(long amount, FluidUnit unit) {
        this.setAmount(this.getAmount() + FluidUnit.convert(amount, unit, this.getUnit()));
    }

    public void decrement(long amount, FluidUnit unit) {
        this.increment(-amount, unit);
    }

    public boolean matches(FluidIngredient ingredient) {
        return ingredient.fluid().matches(this.getFluid()) && FluidUnit.compareVolumes(this, ingredient) >= 0 && Objects.equals(this.getComponents(), ingredient.components());
    }

    public Component getAmountText() {
        FluidUnit displayUnit = FluidReference.getDefaultDisplayUnit();
        return Component.translatable((String)"gui.adorn.fluid_volume", (Object[])new Object[]{FluidUnit.losslessConvert(this.getAmount(), this.getUnit(), displayUnit).resizeFraction(FluidReference.getUnitDenominator(this.getUnit(), displayUnit)), displayUnit.getSymbol()});
    }

    public Component getAmountText(long max, FluidUnit maxUnit) {
        FluidUnit displayUnit = FluidReference.getDefaultDisplayUnit();
        return Component.translatable((String)"gui.adorn.fluid_volume.fraction", (Object[])new Object[]{FluidUnit.losslessConvert(this.getAmount(), this.getUnit(), displayUnit).resizeFraction(FluidReference.getUnitDenominator(this.getUnit(), displayUnit)).toString(), FluidUnit.losslessConvert(max, maxUnit, displayUnit).resizeFraction(FluidReference.getUnitDenominator(maxUnit, displayUnit)).toString(), displayUnit.getSymbol()});
    }

    private static FluidUnit getDefaultDisplayUnit() {
        return ConfigManager.config().client.displayedFluidUnit;
    }

    private static long getUnitDenominator(FluidUnit from, FluidUnit to) {
        if (from.getBucketVolume() == to.getBucketVolume()) {
            return 1L;
        }
        return Math.max(1L, from.getBucketVolume() / to.getBucketVolume());
    }

    public String toString() {
        return "FluidReference(fluid=%s, amount=%d, nbt=%s)".formatted(BuiltInRegistries.FLUID.getKey((Object)this.getFluid()), this.getAmount(), this.getComponents());
    }

    public static boolean areFluidsEqual(FluidReference a, FluidReference b) {
        if (a.isEmpty()) {
            return b.isEmpty();
        }
        return a.getFluid() == b.getFluid() && Objects.equals(a.getComponents(), b.getComponents());
    }

    public static boolean areFluidsAndAmountsEqual(FluidReference a, FluidReference b) {
        if (a.isEmpty()) {
            return b.isEmpty();
        }
        return FluidReference.areFluidsEqual(a, b) && FluidUnit.compareVolumes(a, b) == 0;
    }
}

