/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Set;
import juuxel.adorn.fluid.FluidKeyImpl;
import juuxel.adorn.util.EntryOrTag;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.material.Fluid;

public sealed interface FluidKey
permits FluidKeyImpl.Simple, FluidKeyImpl.OfArray {
    public static final Codec<FluidKey> CODEC = FluidKeyImpl.CODEC;

    public Set<Fluid> getFluids();

    public boolean matches(Fluid var1);

    default public void write(FriendlyByteBuf buf) {
        Set<Fluid> fluids = this.getFluids();
        buf.writeVarInt(fluids.size());
        for (Fluid fluid : fluids) {
            buf.writeVarInt(BuiltInRegistries.FLUID.getId((Object)fluid));
        }
    }

    public static FluidKey load(FriendlyByteBuf buf) {
        int size = buf.readVarInt();
        if (size == 1) {
            return new FluidKeyImpl.Simple(new EntryOrTag.OfEntry<Fluid>((Fluid)BuiltInRegistries.FLUID.byId(buf.readVarInt())));
        }
        ArrayList<FluidKeyImpl.Simple> children = new ArrayList<FluidKeyImpl.Simple>(size);
        for (int i = 0; i < size; ++i) {
            children.add(new FluidKeyImpl.Simple(new EntryOrTag.OfEntry<Fluid>((Fluid)BuiltInRegistries.FLUID.byId(buf.readVarInt()))));
        }
        return new FluidKeyImpl.OfArray(children);
    }
}

