/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.fluid.HasFluidAmount;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.level.material.Fluids;

public interface FluidAmountPredicate {
    public HasFluidAmount getUpperBound();

    public boolean test(long var1, FluidUnit var3);

    public static FluidAmountPredicate exactly(final long amount, final FluidUnit unit) {
        return new FluidAmountPredicate(){
            private final FluidVolume upperBound;
            {
                this.upperBound = new FluidVolume(Fluids.EMPTY, amount, DataComponentPatch.EMPTY, unit);
            }

            @Override
            public HasFluidAmount getUpperBound() {
                return this.upperBound;
            }

            @Override
            public boolean test(long amount2, FluidUnit unit2) {
                return FluidUnit.compareVolumes(amount2, unit2, this.upperBound.getAmount(), this.upperBound.getUnit()) == 0;
            }
        };
    }

    public static FluidAmountPredicate atMost(final long max, final FluidUnit unit) {
        return new FluidAmountPredicate(){
            private final FluidVolume upperBound;
            {
                this.upperBound = new FluidVolume(Fluids.EMPTY, max, DataComponentPatch.EMPTY, unit);
            }

            @Override
            public HasFluidAmount getUpperBound() {
                return this.upperBound;
            }

            @Override
            public boolean test(long amount, FluidUnit unit2) {
                return FluidUnit.compareVolumes(amount, unit2, this.upperBound.getAmount(), this.upperBound.getUnit()) <= 0;
            }
        };
    }
}

