/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.entity;

import juuxel.adorn.block.SeatBlock;
import juuxel.adorn.platform.PlatformBridges;
import juuxel.adorn.util.NbtUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public final class SeatEntity
extends Entity {
    private static final EntityDataAccessor<BlockPos> SEAT_POS = SynchedEntityData.defineId(SeatEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final String NBT_SEAT_POS = "SeatPos";
    private BlockPos seatPos;

    public SeatEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.noPhysics = true;
        this.setInvulnerable(true);
        this.seatPos = BlockPos.containing((Position)this.position());
    }

    private void setSeatPos(BlockPos seatPos) {
        this.seatPos = seatPos;
        this.entityData.set(SEAT_POS, (Object)seatPos);
    }

    public void setPos(BlockPos pos) {
        if (this.level().isClientSide) {
            throw new IllegalStateException("setPos must be called on the logical server");
        }
        this.absMoveTo((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        this.setSeatPos(pos);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        player.startRiding((Entity)this);
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
    }

    protected void removePassenger(Entity passenger) {
        super.removePassenger(passenger);
        this.kill();
    }

    public void kill() {
        this.ejectPassengers();
        if (!this.level().isClientSide) {
            PlatformBridges.get().getNetwork().sendToTracking(this, (Packet<?>)new ClientboundSetPassengersPacket((Entity)this));
        }
        super.kill();
        BlockState state = this.level().getBlockState(this.seatPos);
        if (state.getBlock() instanceof SeatBlock) {
            this.level().setBlockAndUpdate(this.seatPos, (BlockState)state.setValue((Property)SeatBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean isInvisible() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SEAT_POS, (Object)BlockPos.ZERO);
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.seatPos = NbtUtil.getBlockPos(nbt, NBT_SEAT_POS);
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        NbtUtil.putBlockPos(nbt, NBT_SEAT_POS, this.seatPos);
    }

    protected Vec3 getPassengerAttachmentPoint(Entity passenger, EntityDimensions dimensions, float scaleFactor) {
        double d;
        BlockPos seatPos = (BlockPos)this.entityData.get(SEAT_POS);
        BlockState state = this.level().getBlockState(seatPos);
        Block block = state.getBlock();
        if (block instanceof SeatBlock) {
            SeatBlock seat = (SeatBlock)block;
            d = seat.getSittingOffset(this.level(), state, seatPos);
        } else {
            d = 0.0;
        }
        double blockOffset = d;
        double posOffset = this.getY() - (double)seatPos.getY();
        return new Vec3(0.0, blockOffset - posOffset, 0.0);
    }
}

