/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public final class BoughtFromTradingStationCriterion
extends SimpleCriterionTrigger<Conditions> {
    public Codec<Conditions> codec() {
        return Conditions.CODEC;
    }

    public void trigger(ServerPlayer player, ItemStack soldItem) {
        this.trigger(player, conditions -> conditions.matches(soldItem));
    }

    public record Conditions(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> soldItem) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Conditions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Conditions::player), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(Conditions::soldItem)).apply((Applicative)instance, Conditions::new));

        public boolean matches(ItemStack stack) {
            return this.soldItem.map(predicate -> predicate.test(stack)).orElse(true);
        }
    }
}

