/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.config;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import blue.endless.jankson.api.DeserializationException;
import java.io.IOException;
import java.lang.invoke.ConstantBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import juuxel.adorn.config.Config;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.util.InlineServices;
import juuxel.adorn.util.Logging;
import org.slf4j.Logger;

/*
 * Uses jvm11+ dynamic constants - pseudocode provided - see https://www.benf.org/other/cfr/dynamic-constants.html
 */
@InlineServices
public abstract class ConfigManager {
    private static final Jankson JANKSON = Jankson.builder().registerSerializer(FluidUnit.class, (unit, m) -> new JsonPrimitive((Object)unit.getId())).registerDeserializer(JsonPrimitive.class, FluidUnit.class, (json, m) -> Objects.requireNonNullElse(FluidUnit.byId(json.asString()), FluidUnit.LITRE)).build();
    private static final JsonObject DEFAULT = (JsonObject)JANKSON.toJson((Object)new Config());
    private static final Logger LOGGER = Logging.logger();
    private Config config;
    private boolean saveScheduled = false;
    private boolean finalized = false;

    @InlineServices.Getter
    public static ConfigManager get() {
        return  /* dynamic constant */ (Object)ConstantBootstraps.invoke("instance", new Object[]{<init>()});
    }

    public static Config config() {
        return ConfigManager.get().config;
    }

    protected abstract Path getConfigDirectory();

    private Path getConfigPath() {
        return this.getConfigDirectory().resolve("Adorn.json5");
    }

    public void init() {
        this.loadConfig();
    }

    private void loadConfig() {
        Path configPath = this.getConfigPath();
        if (Files.notExists(configPath, new LinkOption[0])) {
            this.save(new Config());
        }
        try {
            Config config;
            JsonObject obj;
            block6: {
                obj = JANKSON.load(Files.readString(configPath));
                try {
                    config = (Config)JANKSON.fromJsonCarefully(obj, Config.class);
                }
                catch (DeserializationException e) {
                    config = (Config)JANKSON.fromJson(obj, Config.class);
                    if (config != null) break block6;
                    throw e;
                }
            }
            if (this.isMissingKeys(obj, DEFAULT)) {
                LOGGER.info("[Adorn] Upgrading config...");
                this.save(config);
            }
            this.config = config;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load Adorn config file!", e);
        }
    }

    public void save() {
        if (this.finalized) {
            this.save(this.config);
        } else {
            this.saveScheduled = true;
        }
    }

    public void finish() {
        this.finalized = true;
        if (this.saveScheduled) {
            this.save();
        }
    }

    private void save(Config config) {
        try {
            Files.writeString(this.getConfigPath(), (CharSequence)JANKSON.toJson((Object)config).toJson(true, true), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("[Adorn] Could not save config file {}", (Object)this.getConfigPath(), (Object)e);
        }
    }

    private boolean isMissingKeys(JsonObject config, JsonObject defaults) {
        for (Map.Entry entry : defaults.entrySet()) {
            if (!config.containsKey(entry.getKey())) {
                return true;
            }
            Object v = entry.getValue();
            if (!(v instanceof JsonObject)) continue;
            JsonObject value = (JsonObject)v;
            JsonObject actual = (JsonObject)config.get(JsonObject.class, (String)entry.getKey());
            return actual == null || this.isMissingKeys(actual, value);
        }
        return false;
    }
}

