/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.rei.client;

import java.util.List;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.compat.rei.AdornReiServer;
import juuxel.adorn.compat.rei.BrewerDisplay;
import juuxel.adorn.compat.rei.client.BrewerCategory;
import juuxel.adorn.compat.rei.client.TradingStationDraggableStackVisitor;
import juuxel.adorn.lib.AdornTags;
import juuxel.adorn.recipe.AdornRecipeTypes;
import juuxel.adorn.recipe.FluidBrewingRecipe;
import juuxel.adorn.recipe.ItemBrewingRecipe;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class AdornReiClient
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new BrewerCategory());
        registry.addWorkstations(AdornReiServer.BREWER, new EntryStack[]{EntryStacks.of((ItemLike)((ItemLike)AdornBlocks.BREWER.get()))});
    }

    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(ItemBrewingRecipe.class, (RecipeType)AdornRecipeTypes.BREWING.get(), entry -> new BrewerDisplay((ItemBrewingRecipe)entry.value()));
        registry.registerRecipeFiller(FluidBrewingRecipe.class, (RecipeType)AdornRecipeTypes.BREWING.get(), entry -> new BrewerDisplay((FluidBrewingRecipe)entry.value()));
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        AdornReiClient.add(registry, AdornTags.SOFAS.item());
        AdornReiClient.add(registry, AdornTags.CHAIRS.item());
        AdornReiClient.add(registry, AdornTags.TABLES.item());
        AdornReiClient.add(registry, AdornTags.DRAWERS.item());
        AdornReiClient.add(registry, AdornTags.KITCHEN_COUNTERS.item());
        AdornReiClient.add(registry, AdornTags.KITCHEN_CUPBOARDS.item());
        AdornReiClient.add(registry, AdornTags.KITCHEN_SINKS.item());
        AdornReiClient.add(registry, AdornTags.POSTS.item());
        AdornReiClient.add(registry, AdornTags.PLATFORMS.item());
        AdornReiClient.add(registry, AdornTags.STEPS.item());
        AdornReiClient.add(registry, AdornTags.SHELVES.item());
        AdornReiClient.add(registry, AdornTags.CHIMNEYS.item());
        AdornReiClient.add(registry, AdornTags.COFFEE_TABLES.item());
        AdornReiClient.add(registry, AdornTags.BENCHES.item());
        AdornReiClient.add(registry, AdornTags.CRATES.item());
        AdornReiClient.add(registry, AdornTags.TABLE_LAMPS.item());
        AdornReiClient.add(registry, AdornTags.CANDLELIT_LANTERNS.item());
        AdornReiClient.add(registry, AdornTags.COPPER_PIPES.item());
        AdornReiClient.add(registry, AdornTags.PAINTED_PLANKS.item());
        AdornReiClient.add(registry, AdornTags.PAINTED_WOOD_SLABS.item());
        AdornReiClient.add(registry, AdornTags.PAINTED_WOOD_STAIRS.item());
        AdornReiClient.add(registry, AdornTags.PAINTED_WOOD_FENCES.item());
        AdornReiClient.add(registry, AdornTags.PAINTED_WOOD_FENCE_GATES.item());
        AdornReiClient.add(registry, AdornTags.PAINTED_WOOD_PRESSURE_PLATES.item());
        AdornReiClient.add(registry, AdornTags.PAINTED_WOOD_BUTTONS.item());
    }

    private static void add(CollapsibleEntryRegistry registry, TagKey<Item> tag) {
        MutableComponent name = Component.translatable((String)Util.makeDescriptionId((String)"tag.item", (ResourceLocation)tag.location()));
        registry.group(tag.location(), (Component)name, (List)EntryIngredients.ofItemTag(tag));
    }

    public void registerScreens(ScreenRegistry registry) {
        registry.registerDraggableStackVisitor((DraggableStackVisitor)new TradingStationDraggableStackVisitor());
    }
}

