/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.rei;

import dev.architectury.fluid.FluidStack;
import java.util.List;
import juuxel.adorn.compat.rei.AdornReiServer;
import juuxel.adorn.fluid.FluidIngredient;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.platform.FluidBridge;
import juuxel.adorn.recipe.FluidBrewingRecipe;
import juuxel.adorn.recipe.ItemBrewingRecipe;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public record BrewerDisplay(EntryIngredient input, EntryIngredient first, EntryIngredient second, EntryIngredient fluid, EntryStack<?> result) implements Display
{
    public BrewerDisplay(ItemBrewingRecipe recipe) {
        this(EntryIngredients.of((ItemLike)((ItemLike)AdornItems.MUG.get())), EntryIngredients.ofIngredient((Ingredient)recipe.firstIngredient()), EntryIngredients.ofIngredient((Ingredient)recipe.secondIngredient()), EntryIngredient.empty(), EntryStacks.of((ItemStack)recipe.result()));
    }

    public BrewerDisplay(FluidBrewingRecipe recipe) {
        this(EntryIngredients.of((ItemLike)((ItemLike)AdornItems.MUG.get())), EntryIngredients.ofIngredient((Ingredient)recipe.firstIngredient()), EntryIngredients.ofIngredient((Ingredient)recipe.secondIngredient()), BrewerDisplay.entryIngredientOf(recipe.fluid()), EntryStacks.of((ItemStack)recipe.result()));
    }

    private static EntryIngredient entryIngredientOf(FluidIngredient fluidIngredient) {
        long amount = FluidUnit.convert(fluidIngredient.getAmount(), fluidIngredient.getUnit(), FluidBridge.get().getFluidUnit());
        List<EntryStack> stacks = fluidIngredient.fluid().getFluids().stream().map(fluid -> EntryStacks.of((FluidStack)FluidStack.create((Fluid)fluid, (long)amount, (DataComponentPatch)fluidIngredient.components()))).toList();
        return EntryIngredient.of(stacks);
    }

    public List<EntryIngredient> getInputEntries() {
        return List.of(this.input, this.first, this.second, this.fluid);
    }

    public List<EntryIngredient> getOutputEntries() {
        return List.of(EntryIngredient.of(this.result));
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return AdornReiServer.BREWER;
    }

    public static final class Serializer
    implements DisplaySerializer<BrewerDisplay> {
        public CompoundTag save(CompoundTag tag, BrewerDisplay display) {
            tag.put("Input", (Tag)display.input.saveIngredient());
            tag.put("FirstIngredient", (Tag)display.first.saveIngredient());
            tag.put("SecondIngredient", (Tag)display.second.saveIngredient());
            tag.put("Fluid", (Tag)display.fluid.saveIngredient());
            tag.put("Result", (Tag)display.result.saveStack());
            return tag;
        }

        public BrewerDisplay read(CompoundTag tag) {
            EntryIngredient input = EntryIngredient.read((ListTag)tag.getList("Input", 10));
            EntryIngredient first = EntryIngredient.read((ListTag)tag.getList("FirstIngredient", 10));
            EntryIngredient second = EntryIngredient.read((ListTag)tag.getList("SecondIngredient", 10));
            EntryIngredient fluid = EntryIngredient.read((ListTag)tag.getList("Fluid", 10));
            EntryStack result = EntryStack.read((CompoundTag)tag.getCompound("Result"));
            return new BrewerDisplay(input, first, second, fluid, result);
        }
    }
}

