/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import java.util.Optional;
import juuxel.adorn.client.gui.screen.TradingStationScreen;
import juuxel.adorn.menu.TradingStationMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class TradingStationDragDropHandler
implements EmiDragDropHandler<TradingStationScreen> {
    public boolean dropStack(TradingStationScreen screen, EmiIngredient stack, int x, int y) {
        ItemStack itemStack = TradingStationDragDropHandler.single(stack.getEmiStacks()).map(EmiStack::getItemStack).orElse(null);
        if (itemStack == null || itemStack.isEmpty() || !TradingStationMenu.isValidItem(itemStack)) {
            return false;
        }
        for (Slot slot : new Slot[]{((TradingStationMenu)screen.getMenu()).getSellingSlot(), ((TradingStationMenu)screen.getMenu()).getPriceSlot()}) {
            int slotX = slot.x + screen.getPanelX();
            int slotY = slot.y + screen.getPanelY();
            if (slotX > x || slotX >= slotX + 16 || slotY > y || y >= slotY + 16) continue;
            screen.updateTradeStack(slot, itemStack);
            return true;
        }
        return false;
    }

    private static <T> Optional<T> single(List<T> ts) {
        return ts.size() == 1 ? Optional.of(ts.getFirst()) : Optional.empty();
    }
}

